/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.SymmetricQRAlgorithm;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd.SVDDecomposition;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricSVD
implements SVDDecomposition {
    private final double[] const;
    private final DiagonalMatrix case;
    private final ImmutableMatrix false;
    private final ImmutableMatrix enum;

    public SymmetricSVD(Matrix A2, double epsilon) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "symmetric SVD algorithm applies only to square matrix", new Object[0]);
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(A2, 0.0), "symmetric SVD algorithm applies only to symmetric matrix", new Object[0]);
        SymmetricQRAlgorithm a2 = new SymmetricQRAlgorithm(A2, epsilon);
        List<Double> a3 = a2.getEigenvalues();
        double[] a4 = DoubleUtils.collection2DoubleArray(a3);
        Matrix a5 = a2.Q();
        Matrix a6 = a5.deepCopy();
        for (int a7 = 0; a7 < a4.length; ++a7) {
            if (!(a4[a7] < 0.0)) continue;
            int n = a7;
            a4[n] = a4[n] * -1.0;
            SymmetricSVD.do(a6, a7 + 1);
        }
        SortedUV a8 = SymmetricSVD.do(a5, a6, a4);
        this.false = new ImmutableMatrix(a8.getU());
        this.enum = new ImmutableMatrix(a8.getV());
        this.const = a8.getEigen();
        this.case = new DiagonalMatrix(this.const);
    }

    @Override
    public DiagonalMatrix D() {
        return this.case;
    }

    public SymmetricSVD(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    private static void do(Matrix a2, int a3) {
        for (int a4 = 1; a4 <= a2.nRows(); ++a4) {
            a2.set(a4, a3, -a2.get(a4, a3));
        }
    }

    @Override
    public ImmutableMatrix V() {
        return this.enum;
    }

    @Override
    public ImmutableMatrix Ut() {
        return new ImmutableMatrix(this.false.t());
    }

    @Override
    public ImmutableMatrix U() {
        return this.false;
    }

    private static SortedUV do(Matrix a2, Matrix a3, double[] a4) {
        Object a5;
        int a6 = a2.nCols();
        ArrayList<UVEigen> a7 = new ArrayList<UVEigen>(a6);
        for (int a8 = 1; a8 <= a6; ++a8) {
            a7.add(new UVEigen(a2.getColumn(a8), a3.getColumn(a8), Math.abs(a4[a8 - 1])));
        }
        Collections.sort(a7);
        ArrayList<Vector> a9 = new ArrayList<Vector>(a6);
        ArrayList<Vector> a10 = new ArrayList<Vector>(a6);
        double[] a11 = new double[a6];
        for (int a12 = 0; a12 < a6; ++a12) {
            a5 = (UVEigen)a7.get(a12);
            a9.add(((UVEigen)a5).enum);
            a10.add(((UVEigen)a5).case);
            a11[a12] = ((UVEigen)a5).false;
        }
        Matrix a13 = MatrixFactory.cbind(a9);
        a5 = MatrixFactory.cbind(a10);
        return new SortedUV(a13, (Matrix)a5, a11);
    }

    @Override
    public double[] getSingularValues() {
        return (double[])this.const.clone();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class UVEigen
    implements Comparable<UVEigen> {
        private final Vector case;
        private final double false;
        private final Vector enum;

        @Override
        public int compareTo(UVEigen that) {
            return -DoubleUtils.compare(this.false, that.false, 0.0);
        }

        private UVEigen(Vector a2, Vector a3, double a4) {
            UVEigen a5;
            a5.enum = a2;
            a5.case = a3;
            a5.false = a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class SortedUV {
        private final Matrix case;
        private final double[] false;
        private final Matrix enum;

        public Matrix getV() {
            return this.enum;
        }

        public double[] getEigen() {
            return this.false;
        }

        private SortedUV(Matrix a2, Matrix a3, double[] a4) {
            SortedUV a5;
            a5.case = a2;
            a5.enum = a3;
            a5.false = a4;
        }

        public Matrix getU() {
            return this.case;
        }
    }
}

