/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LDLt {
    private DiagonalMatrix const;
    private final int case;
    private final Matrix false;
    private LowerTriangularMatrix enum;

    public LDLt(Matrix A2, double epsilon) {
        if (!MatrixPropertyUtils.isSymmetric(A2, epsilon)) {
            throw new IllegalArgumentException("LDL decomposition applies to only symmetric matrix");
        }
        this.case = A2.nRows();
        this.false = A2;
        this.do();
    }

    private void do() {
        LDLt a2;
        a2.enum = new LowerTriangularMatrix(a2.case);
        a2.const = new DiagonalMatrix(a2.case);
        for (int a3 = 1; a3 <= a2.case; ++a3) {
            for (int a4 = 1; a4 < a3; ++a4) {
                double a5 = a2.const.get(a4, a4);
                if (DoubleUtils.isZero(a5, 0.0)) {
                    a2.enum.set(a3, a4, 0.0);
                    continue;
                }
                double a6 = a2.false.get(a3, a4);
                for (int a7 = 1; a7 <= a4 - 1; ++a7) {
                    a6 -= a2.enum.get(a3, a7) * a2.enum.get(a4, a7) * a2.const.get(a7, a7);
                }
                a2.enum.set(a3, a4, a6 /= a2.const.get(a4, a4));
            }
            a2.enum.set(a3, a3, 1.0);
            double a8 = a2.false.get(a3, a3);
            for (int a9 = 1; a9 <= a3 - 1; ++a9) {
                a8 -= a2.enum.get(a3, a9) * a2.enum.get(a3, a9) * a2.const.get(a9, a9);
            }
            a2.const.set(a3, a3, a8);
        }
    }

    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.const);
    }

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.enum);
    }

    public UpperTriangularMatrix Lt() {
        return this.enum.t();
    }

    public LDLt(Matrix A2) {
        this(A2, 0.0);
    }
}

