/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;

public final class ThomasAlgorithm {
    public Vector solve(TridiagonalMatrix A2, Vector d) {
        int a2;
        DenseVector a3 = A2.getSubDiagonal();
        DenseVector a4 = A2.getDiagonal();
        DenseVector a5 = A2.getSuperDiagonal();
        DenseVector a6 = new DenseVector(d);
        int a7 = d.size();
        if (a4.get(1) == 0.0) {
            throw new ArithmeticException("Divide by zero! Try LU solver");
        }
        a5.set(1, 1.0 * a5.get(1) / a4.get(1));
        a6.set(1, 1.0 * d.get(1) / a4.get(1));
        for (a2 = 2; a2 <= a7; ++a2) {
            double a8 = a4.get(a2) - a3.get(a2 - 1) * a5.get(a2 - 1);
            if (a8 == 0.0) {
                throw new ArithmeticException("Divide by zero! Try LU solver");
            }
            if (a2 < a7) {
                a5.set(a2, a5.get(a2) / a8);
            }
            a6.set(a2, (a6.get(a2) - a6.get(a2 - 1) * a3.get(a2 - 1)) / a8);
        }
        for (a2 = a7 - 1; a2 >= 1; --a2) {
            a6.set(a2, a6.get(a2) - a5.get(a2) * a6.get(a2 + 1));
        }
        return a6;
    }
}

