/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.datastructure.Table;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GivensMatrix
implements Matrix {
    private static int true;
    private final double do;
    private final int long;
    private final double super;
    private static int char;
    private final int new;
    private final int const;
    private static final MatrixMathOperation case;
    private static int false;
    private static final ParallelExecutor enum;

    public String toString() {
        Object a2 = new DenseMatrix(this.const, this.const).ONE();
        a2.set(this.long, this.long, this.do);
        a2.set(this.new, this.new, this.do);
        a2.set(this.long, this.new, this.super);
        a2.set(this.new, this.long, -this.super);
        return a2.toString();
    }

    @Override
    public Matrix minus(Matrix that) {
        return case.minus(this, that);
    }

    public static GivensMatrix CtorToZeroOutEntry(Matrix A2, int i, int j2) {
        double a2 = A2.get(i == 1 ? A2.nRows() : i - 1, j2);
        double a3 = A2.get(i, j2);
        return GivensMatrix.CtorToRotateRows(A2.nRows(), i == 1 ? A2.nRows() : i - 1, i, a2, a3);
    }

    @Override
    public Vector multiply(Vector v) {
        Vector a2 = v.deepCopy();
        this.multiplyInPlace(a2);
        return a2;
    }

    static {
        case = new AutoParallelMatrixMathOperation();
        enum = new ParallelExecutor(GivensMatrix.class.getSimpleName());
        char = 1000;
        false = 1000;
        true = char * false;
    }

    private static int do(int a2, int a3) {
        return 4;
    }

    public GivensMatrix(GivensMatrix that) {
        this(that.const, that.long, that.new, that.do, that.super);
    }

    public GivensMatrix(int dim, int i, int j2, double c2, double s) {
        ArgumentAssertion.assertPositive(i, "i");
        ArgumentAssertion.assertPositive(j2, "j");
        ArgumentAssertion.assertTrue(i <= dim && j2 <= dim && i != j2, "invalid specification", new Object[0]);
        this.const = dim;
        this.long = i;
        this.new = j2;
        this.do = c2;
        this.super = s;
    }

    @Override
    @Deprecated
    public void set(int row, int col, double value) {
        throw new MatrixAccessException("GivensMatrix is immutable");
    }

    public static Matrix product(GivensMatrix[] Gs) {
        if (Gs.length == 0) {
            return null;
        }
        if (Gs.length * Gs[0].nRows() < true) {
            return GivensMatrix.do(Gs);
        }
        return GivensMatrix.break(Gs);
    }

    @Override
    public GivensMatrix t() {
        return new GivensMatrix(this.const, this.long, this.new, this.do, -this.super);
    }

    private static Matrix break(final GivensMatrix[] a2) {
        int a3 = GivensMatrix.do(a2.length, a2[0].nRows());
        final int a4 = (int)Math.ceil((double)a2.length / (double)a3);
        ArrayList<1> a5 = new ArrayList<1>(a3);
        int a6 = 0;
        while (a6 < a3) {
            final int a7 = a6++;
            a5.add(new Callable<Matrix>(){
                {
                    1 a22;
                }

                @Override
                public Matrix call() throws Exception {
                    int a22 = a7 * a4;
                    int a3 = Math.min(a22 + a4, a2.length);
                    GivensMatrix[] a42 = Arrays.copyOfRange(a2, a22, a3);
                    return GivensMatrix.do(a42);
                }
            });
        }
        try {
            List a8 = enum.executeAll(a5);
            Matrix a9 = (Matrix)a8.get(0);
            for (int a10 = 1; a10 < a8.size(); ++a10) {
                a9 = a9.multiply((Matrix)a8.get(a10));
            }
            return a9;
        }
        catch (MultipleExecutionException a11) {
            return GivensMatrix.do(a2);
        }
    }

    public double s() {
        return this.super;
    }

    @Override
    public Matrix add(Matrix that) {
        return case.add(this, that);
    }

    @Override
    public GivensMatrix deepCopy() {
        return new GivensMatrix(this);
    }

    public static GivensMatrix CtorToRotateColumns(int dim, int j1, int j2, double a2, double b2) {
        double a3;
        double a4;
        double a5 = Math.abs(a2) + Math.abs(b2);
        if (a5 == 0.0) {
            a4 = 1.0;
            a3 = 0.0;
        } else {
            double a6 = a2 / a5;
            double a7 = b2 / a5;
            double a8 = a5 * Math.hypot(a6, a7);
            a4 = a2 / a8;
            a3 = b2 / a8;
        }
        return new GivensMatrix(dim, j1, j2, a4, -a3);
    }

    public static GivensMatrix Ctor2x2(double c2, double s) {
        return new GivensMatrix(2, 1, 2, c2, s);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!GivensMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        GivensMatrix a2 = (GivensMatrix)obj;
        if (this.const != a2.const) {
            return false;
        }
        if (this.long != a2.long) {
            return false;
        }
        if (this.new != a2.new) {
            return false;
        }
        if (Double.doubleToLongBits(this.do) != Double.doubleToLongBits(a2.do)) {
            return false;
        }
        return Double.doubleToLongBits(this.super) == Double.doubleToLongBits(a2.super);
    }

    @Override
    public Matrix scaled(double c2) {
        return case.scaled(this, c2);
    }

    public Matrix rightMultiply(Matrix A2) {
        DenseMatrix a2 = new DenseMatrix(A2);
        this.rightMultiplyInPlace(a2);
        return a2;
    }

    public double c() {
        return this.do;
    }

    public double rho() {
        double a2 = DoubleUtils.isZero(this.do, 0.0) ? 1.0 : (DoubleUtils.compare(Math.abs(this.super), Math.abs(this.do), 0.0) < 0 ? Math.signum(this.do) * this.super / 2.0 : 2.0 * Math.signum(this.super) / this.do);
        return a2;
    }

    @Override
    @Deprecated
    public Matrix ZERO() {
        throw new UnsupportedOperationException("no zero matrix for GivensMatrix");
    }

    public static GivensMatrix CtorToZeroOutEntryByTranspose(Matrix A2, int i, int j2) {
        double a2 = A2.get(i == 1 ? A2.nRows() : i - 1, j2);
        double a3 = A2.get(i, j2);
        return GivensMatrix.CtorToRotateColumns(A2.nRows(), i == 1 ? A2.nRows() : i - 1, i, a2, a3);
    }

    @Override
    public int nRows() {
        return this.const;
    }

    @Override
    public double get(int i, int j2) {
        if (i == this.long && j2 == this.long) {
            return this.do;
        }
        if (i == this.new && j2 == this.new) {
            return this.do;
        }
        if (i == this.long && j2 == this.new) {
            return this.super;
        }
        if (i == this.new && j2 == this.long) {
            return -this.super;
        }
        if (i == j2) {
            return 1.0;
        }
        return 0.0;
    }

    public static Matrix product(List<GivensMatrix> Gs) {
        return GivensMatrix.product(Gs.toArray(new GivensMatrix[Gs.size()]));
    }

    public Matrix multiplyInPlace(Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, A2);
        int a2 = A2.nCols();
        for (int a3 = 1; a3 <= a2; ++a3) {
            double a4 = A2.get(this.long, a3);
            double a5 = A2.get(this.new, a3);
            if (a4 == 0.0 && a5 == 0.0) continue;
            A2.set(this.long, a3, this.do * a4 + this.super * a5);
            A2.set(this.new, a3, -this.super * a4 + this.do * a5);
        }
        return A2;
    }

    @Override
    public int nCols() {
        return this.const;
    }

    @Deprecated
    public Vector rotate(Vector x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int j() {
        return this.new;
    }

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        DenseVector a2 = new DenseVector(this.const, 0.0);
        a2.set(j2, this.get(j2, j2));
        a2.set(this.long, this.get(this.long, j2));
        a2.set(this.new, this.get(this.new, j2));
        return a2;
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    public static GivensMatrix CtorToRotateRows(int dim, int i1, int i2, double a2, double b2) {
        double a3;
        double a4;
        double a5 = Math.abs(a2) + Math.abs(b2);
        if (DoubleUtils.isZero(a5, 0.0)) {
            a4 = 1.0;
            a3 = 0.0;
        } else {
            double a6 = a5 * Math.sqrt(a2 / a5 * a2 / a5 + b2 / a5 * b2 / a5);
            a4 = a2 / a6;
            a3 = b2 / a6;
        }
        return new GivensMatrix(dim, i1, i2, a4, a3);
    }

    public static GivensMatrix CtorFromRho(int dim, int i, int j2, double rho) {
        double a2;
        double a3;
        ArgumentAssertion.assertPositive(i, "i");
        ArgumentAssertion.assertPositive(j2, "j");
        ArgumentAssertion.assertTrue(i <= dim && j2 <= dim && i != j2, "invalid specification", new Object[0]);
        if (DoubleUtils.equal(rho, 1.0, 0.0)) {
            a3 = 1.0;
            a2 = 0.0;
        } else if (DoubleUtils.compare(Math.abs(rho), 1.0, 0.0) < 0) {
            a3 = 2.0 * rho;
            a2 = Math.sqrt(1.0 - a3 * a3);
        } else {
            a2 = 2.0 / rho;
            a3 = Math.sqrt(1.0 - a2 * a2);
        }
        return new GivensMatrix(dim, i, j2, a2, a3);
    }

    public Vector multiplyInPlace(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        double a2 = v.get(this.long);
        double a3 = v.get(this.new);
        v.set(this.long, a2 * this.do + a3 * this.super);
        v.set(this.new, a3 * this.do - a2 * this.super);
        return v;
    }

    @Override
    public GivensMatrix ONE() {
        return new GivensMatrix(this.const, 1, 2, 1.0, 0.0);
    }

    @Override
    public Vector getRow(int i) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        DenseVector a2 = new DenseVector(this.const, 0.0);
        a2.set(i, this.get(i, i));
        a2.set(this.long, this.get(i, this.long));
        a2.set(this.new, this.get(i, this.new));
        return a2;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 29 * a2 + this.const;
        a2 = 29 * a2 + this.long;
        a2 = 29 * a2 + this.new;
        a2 = 29 * a2 + (int)(Double.doubleToLongBits(this.do) ^ Double.doubleToLongBits(this.do) >>> 32);
        a2 = 29 * a2 + (int)(Double.doubleToLongBits(this.super) ^ Double.doubleToLongBits(this.super) >>> 32);
        return a2;
    }

    public int i() {
        return this.long;
    }

    @Override
    public Matrix multiply(Matrix A2) {
        DenseMatrix a2 = new DenseMatrix(A2);
        this.multiplyInPlace(a2);
        return a2;
    }

    private static Matrix do(GivensMatrix[] a2) {
        Matrix a3 = MatrixFactory.identity(a2[0].const, a2[0].const);
        for (int a4 = a2.length - 1; a4 >= 0; --a4) {
            if (a2[a4] == null) continue;
            a3 = a2[a4].multiplyInPlace(a3);
        }
        return a3;
    }

    public Matrix rightMultiplyInPlace(Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)A2, this);
        int a2 = A2.nRows();
        for (int a3 = 1; a3 <= a2; ++a3) {
            double a4 = A2.get(a3, this.long);
            double a5 = A2.get(a3, this.new);
            if (a4 == 0.0 && a5 == 0.0) continue;
            A2.set(a3, this.long, this.do * a4 - this.super * a5);
            A2.set(a3, this.new, this.super * a4 + this.do * a5);
        }
        return A2;
    }
}

