/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.datastructure.Table;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PermutationMatrix
implements Matrix {
    private final int const;
    private static final int case = 1000;
    private int false = 1;
    private int[] enum;

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        DenseVector a2 = new DenseVector(this.const);
        for (int a3 = 1; a3 <= this.const; ++a3) {
            if (this.enum[a3] != j2) continue;
            a2.set(a3, 1.0);
            break;
        }
        return a2;
    }

    @Override
    public PermutationMatrix deepCopy() {
        return new PermutationMatrix(this);
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 59 * a2 + this.const;
        a2 = 59 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        return a2;
    }

    public String toString() {
        return new DenseMatrix(this).toString();
    }

    @Override
    public Matrix ZERO() {
        throw new UnsupportedOperationException("permutation matrix cannot be zero");
    }

    @Override
    public PermutationMatrix t() {
        PermutationMatrix a2 = new PermutationMatrix(this.const);
        for (int a3 = 1; a3 <= this.const; ++a3) {
            a2.enum[this.enum[a3]] = a3;
        }
        return a2;
    }

    public PermutationMatrix(int[] data) {
        int a2;
        int a3;
        this.const = data.length;
        this.enum = new int[this.const + 1];
        boolean[] a4 = new boolean[this.const + 1];
        for (a3 = 1; a3 <= this.const; ++a3) {
            this.enum[a3] = a2 = data[a3 - 1];
            a4[a2] = true;
        }
        a3 = 1;
        for (a2 = 1; a2 <= this.const; ++a2) {
            a3 &= a4[a2];
        }
        if (a3 == 0) {
            throw new IllegalArgumentException("data is not a permutation matrix");
        }
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DenseMatrix a2 = new DenseMatrix(that);
        for (int a3 = 1; a3 < this.enum.length; ++a3) {
            a2.set(a3, this.enum[a3], 1.0 - a2.get(a3, this.enum[a3]));
        }
        return a2;
    }

    public PermutationMatrix(PermutationMatrix P) {
        this.const = P.const;
        this.enum = Arrays.copyOf(P.enum, P.enum.length);
        this.false = P.false;
    }

    @Override
    public PermutationMatrix ONE() {
        return new PermutationMatrix(this.const);
    }

    @Override
    @Deprecated
    public void set(int i, int j2, double value) throws MatrixAccessException {
        throw new UnsupportedOperationException("Please use swapRow or swapColumn instead.");
    }

    @Override
    public int nCols() {
        return this.const;
    }

    static {
        Package.validate("BASIC");
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Vector multiply(Vector v) {
        double[] a2 = new double[v.size()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = v.get(this.enum[a3 + 1]);
        }
        DenseVector a4 = new DenseVector(a2);
        return a4;
    }

    public void moveRow2End(int i) {
        DimensionCheck.throwIfInvalidRow(this, i);
        int a2 = this.enum[i];
        for (int a3 = i; a3 < this.nRows(); ++a3) {
            this.enum[a3] = this.enum[a3 + 1];
        }
        this.enum[this.nRows()] = a2;
    }

    @Override
    public int nRows() {
        return this.const;
    }

    public PermutationMatrix(int dim) {
        this.const = dim;
        this.enum = new int[dim + 1];
        for (int a2 = 0; a2 <= dim; ++a2) {
            this.enum[a2] = a2;
        }
    }

    public Matrix rightMultiply(final Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)A2, this);
        int a2 = A2.nCols();
        final Vector[] a3 = new Vector[a2];
        try {
            ParallelExecutor.getSharedInstance().conditionalForLoop(a2 >= 1000, 1, a2 + 1, new LoopBody(){

                @Override
                public void run(int i) throws Exception {
                    a3[((PermutationMatrix)PermutationMatrix.this).enum[i] - 1] = A2.getColumn(i);
                }
                {
                    1 a2;
                }
            });
        }
        catch (MultipleExecutionException a4) {
            for (int a5 = 1; a5 <= a2; ++a5) {
                a3[this.enum[a5] - 1] = A2.getColumn(a5);
            }
        }
        Matrix a6 = MatrixFactory.cbind(a3);
        return a6;
    }

    @Override
    public Matrix multiply(final Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, A2);
        int a2 = A2.nRows();
        final Vector[] a3 = new Vector[a2];
        try {
            ParallelExecutor.getSharedInstance().conditionalForLoop(a2 >= 1000, 1, a2 + 1, new LoopBody(){
                {
                    2 a2;
                }

                @Override
                public void run(int i) throws Exception {
                    a3[i - 1] = A2.getRow(PermutationMatrix.this.enum[i]);
                }
            });
        }
        catch (MultipleExecutionException a4) {
            for (int a5 = 1; a5 <= a2; ++a5) {
                a3[a5 - 1] = A2.getRow(this.enum[a5]);
            }
        }
        Matrix a6 = MatrixFactory.rbind(a3);
        return a6;
    }

    public void moveColumn2End(int j2) {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        for (int a2 = 1; a2 <= this.nRows(); ++a2) {
            if (this.enum[a2] == j2) {
                this.enum[a2] = this.nCols();
                continue;
            }
            if (this.enum[a2] <= j2) continue;
            int n = a2;
            this.enum[n] = this.enum[n] - 1;
        }
    }

    public double sign() {
        return Math.signum(this.false);
    }

    public void swapRow(int i1, int i2) {
        DimensionCheck.throwIfInvalidRow(this, i1);
        DimensionCheck.throwIfInvalidRow(this, i2);
        int a2 = this.enum[i1];
        this.enum[i1] = this.enum[i2];
        this.enum[i2] = a2;
        this.false *= -1;
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        DenseMatrix a2 = new DenseMatrix(that);
        for (int a3 = 1; a3 < this.enum.length; ++a3) {
            a2.set(a3, this.enum[a3], 1.0 + a2.get(a3, this.enum[a3]));
        }
        return a2;
    }

    @Override
    public Matrix scaled(double scalar) {
        DenseMatrix a2 = new DenseMatrix(this.const, this.const);
        for (int a3 = 1; a3 < this.enum.length; ++a3) {
            a2.set(a3, this.enum[a3], scalar);
        }
        return a2;
    }

    @Override
    public Vector getRow(int i) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        DenseVector a2 = new DenseVector(this.const);
        a2.set(this.enum[i], 1.0);
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!PermutationMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        PermutationMatrix a2 = (PermutationMatrix)obj;
        if (this.const != a2.const) {
            return false;
        }
        return this.enum == a2.enum || this.enum != null && Arrays.equals(this.enum, a2.enum);
    }

    public void swapColumn(int j1, int j2) {
        DimensionCheck.throwIfInvalidColumn(this, j1);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        for (int a2 = 1; a2 <= this.const; ++a2) {
            if (this.enum[a2] == j1) {
                this.enum[a2] = j2;
                continue;
            }
            if (this.enum[a2] != j2) continue;
            this.enum[a2] = j1;
        }
        this.false *= -1;
    }

    @Override
    public double get(int i, int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        DimensionCheck.throwIfInvalidColumn(this, i);
        double a2 = 0.0;
        if (this.enum[i] == j2) {
            a2 = 1.0;
        }
        return a2;
    }
}

