/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.RowMajorDenseData;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.datastructure.Table;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DenseMatrix
implements Matrix,
Densifiable {
    private static final MatrixMathOperation case = new AutoParallelMatrixMathOperation();
    private final RowMajorDenseData false;
    private static final int enum = 10000;

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        if (!(that instanceof DenseMatrix)) {
            return case.multiply((MatrixAccess)this, that);
        }
        DenseMatrix a2 = ((DenseMatrix)that).t();
        final double[] a3 = this.false.asArray();
        final double[] a4 = a2.false.asArray();
        final double[] a5 = new double[this.nRows() * that.nCols()];
        final int a6 = this.nCols();
        final int a7 = that.nCols();
        try {
            ParallelExecutorInstanceHolder.enum.conditionalForLoop(a3.length >= 10000, 0, a3.length, a6, new LoopBody(){
                {
                    1 a2;
                }

                @Override
                public void run(int i) throws Exception {
                    int a2 = i / a6 * a7;
                    int a32 = i + a6;
                    for (int a42 = 0; a42 < a4.length; a42 += a6) {
                        double a52 = 0.0;
                        int a62 = i;
                        int a72 = a42;
                        while (a62 < a32) {
                            a52 += a3[a62] * a4[a72];
                            ++a62;
                            ++a72;
                        }
                        a5[a2++] = a52;
                    }
                }
            });
        }
        catch (MultipleExecutionException a8) {
            throw new RuntimeException(a8);
        }
        DenseMatrix a9 = new DenseMatrix(a5, this.nRows(), that.nCols());
        return a9;
    }

    @Override
    public DenseMatrix deepCopy() {
        return new DenseMatrix(this);
    }

    @Override
    public DenseMatrix toDense() {
        return new DenseMatrix(this);
    }

    public DenseMatrix(DenseMatrix A2) {
        this((RowMajorDenseData)A2.false.deepCopy());
    }

    public DenseMatrix(Matrix A2) {
        if (A2 instanceof DenseMatrix) {
            this.false = (RowMajorDenseData)((DenseMatrix)A2).false.deepCopy();
            return;
        }
        int a2 = A2.nRows();
        int a3 = A2.nCols();
        if (A2 instanceof Densifiable) {
            DenseMatrix a4 = ((Densifiable)((Object)A2)).toDense();
            double[] a5 = a4.false.asArray();
            this.false = new RowMajorDenseData(a5, a2, a3);
            return;
        }
        double[] a6 = new double[A2.nRows() * A2.nCols()];
        int a7 = 0;
        for (int a8 = 1; a8 <= a2; ++a8) {
            for (int a9 = 1; a9 <= a3; ++a9) {
                a6[a7++] = A2.get(a8, a9);
            }
        }
        this.false = new RowMajorDenseData(a6, a2, a3);
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof DenseMatrix) {
            return new DenseMatrix((RowMajorDenseData)this.false.minus(((DenseMatrix)that).false));
        }
        return case.minus(this, that);
    }

    public void setColumn(int j2, Vector v) {
        ArgumentAssertion.assertTrue(v.size() == this.nRows(), "vector v has the wrong dimension", new Object[0]);
        for (int a2 = 1; a2 <= this.nRows(); ++a2) {
            this.false.set(a2, j2, v.get(a2));
        }
    }

    @Override
    public DenseMatrix ONE() {
        int a2 = this.nCols();
        int a3 = 0;
        double[] a4 = new double[this.nRows() * a2];
        for (int a5 = 0; a5 < a4.length && a3 < a2; ++a3, a5 += a2) {
            a4[a5 + a3] = 1.0;
        }
        DenseMatrix a6 = new DenseMatrix(a4, this.nRows(), a2);
        return a6;
    }

    private DenseMatrix(RowMajorDenseData a2) {
        DenseMatrix a3;
        a3.false = a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!DenseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        DenseMatrix a2 = (DenseMatrix)obj;
        return this.false == a2.false || this.false != null && this.false.equals(a2.false);
    }

    public DenseMatrix(Vector v) {
        this(v.toArray(), v.size(), 1);
    }

    public Vector getRow(int i, int beginCol, int endCol) {
        int a2 = this.nCols();
        ArgumentAssertion.assertRange(i, 1, this.nRows(), "i");
        ArgumentAssertion.assertRange(beginCol, 1, a2, "beginCol");
        ArgumentAssertion.assertRange(endCol, 1, a2, "endCol");
        int a3 = a2 * (i - 1);
        double[] a4 = Arrays.copyOfRange(this.false.asArray(), a3 + beginCol - 1, a3 + endCol);
        return new DenseVector(a4);
    }

    @Override
    public int nCols() {
        return this.false.nCols();
    }

    @Override
    public int nRows() {
        return this.false.nRows();
    }

    @Override
    public void set(int i, int j2, double value) throws MatrixAccessException {
        this.false.set(i, j2, value);
    }

    @Override
    public DenseMatrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols());
    }

    @Override
    public Vector multiply(final Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        final int a2 = this.nCols();
        final double[] a3 = this.false.asArray();
        final double[] a4 = new double[this.nRows()];
        try {
            ParallelExecutorInstanceHolder.enum.conditionalForLoop(a4.length >= 10000, 0, a4.length, 1, new LoopBody(){
                {
                    3 a22;
                }

                @Override
                public void run(int i) throws Exception {
                    double a22 = 0.0;
                    for (int a32 = 0; a32 < v.size(); ++a32) {
                        a22 += a3[i * a2 + a32] * v.get(a32 + 1);
                    }
                    a4[i] = a22;
                }
            });
        }
        catch (MultipleExecutionException a5) {
            throw new RuntimeException(a5);
        }
        DenseVector a6 = new DenseVector(a4);
        return a6;
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof DenseMatrix) {
            return new DenseMatrix((RowMajorDenseData)this.false.add(((DenseMatrix)that).false));
        }
        return case.add(this, that);
    }

    @Override
    public double get(int i, int j2) throws MatrixAccessException {
        return this.false.get(i, j2);
    }

    public Vector getColumn(int j2, int beginRow, int endRow) {
        int a2 = this.nRows();
        int a3 = this.nCols();
        ArgumentAssertion.assertRange(j2, 1, a3, "j");
        ArgumentAssertion.assertRange(beginRow, 1, a2, "beginRow");
        ArgumentAssertion.assertRange(endRow, 1, a2, "endRow");
        double[] a4 = this.false.asArray();
        double[] a5 = new double[endRow - beginRow + 1];
        int a6 = 0;
        int a7 = j2 - 1 + (beginRow - 1) * a3;
        while (a6 <= endRow - beginRow) {
            a5[a6] = a4[a7];
            ++a6;
            a7 += a3;
        }
        return new DenseVector(a5);
    }

    @Override
    public Vector getRow(int i) {
        return this.getRow(i, 1, this.nCols());
    }

    @Override
    public DenseMatrix scaled(double c2) {
        return new DenseMatrix((RowMajorDenseData)this.false.scaled(c2));
    }

    public void setRow(int i, Vector v) {
        ArgumentAssertion.assertTrue(v.size() == this.nCols(), "vector v has the wrong dimension", new Object[0]);
        for (int a2 = 1; a2 <= this.nCols(); ++a2) {
            this.false.set(i, a2, v.get(a2));
        }
    }

    @Override
    public DenseMatrix t() {
        final int a2 = this.nRows();
        final int a3 = this.nCols();
        final double[] a4 = this.false.asArray();
        final double[] a5 = new double[a4.length];
        try {
            ParallelExecutorInstanceHolder.enum.conditionalForLoop(a4.length >= 10000, 0, a3, new LoopBody(){
                {
                    2 a22;
                }

                @Override
                public void run(int i) throws Exception {
                    int a22 = i * a2;
                    int a32 = a22 + a2;
                    int a42 = a22;
                    int a52 = i;
                    while (a42 < a32) {
                        a5[a42] = a4[a52];
                        ++a42;
                        a52 += a3;
                    }
                }
            });
        }
        catch (MultipleExecutionException a6) {
            throw new RuntimeException(a6);
        }
        DenseMatrix a7 = new DenseMatrix(a5, a3, a2);
        return a7;
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 41 * a2 + (this.false != null ? this.false.hashCode() : 0);
        return a2;
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    public DenseMatrix(double[][] data) {
        this(RowMajorDenseData.convertFrom2dArray(data), data.length, data[0].length);
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    protected DenseMatrix(DenseMatrix A2, boolean copy) {
        this.false = (RowMajorDenseData)(copy ? A2.false.deepCopy() : A2.false);
    }

    public DenseMatrix(int nRows, int nCols) {
        this.false = new RowMajorDenseData(nRows, nCols);
    }

    @Override
    public Vector getColumn(int j2) {
        return this.getColumn(j2, 1, this.nRows());
    }

    public DenseMatrix(double[] data, int nRows, int nCols) {
        ArgumentAssertion.assertTrue(data.length == nRows * nCols, "the data length does not match the matrix dimension", new Object[0]);
        this.false = new RowMajorDenseData(data, nRows, nCols);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ParallelExecutorInstanceHolder {
        private static final ParallelExecutor enum = new ParallelExecutor(DenseMatrix.class.getSimpleName());

        private ParallelExecutorInstanceHolder() {
            ParallelExecutorInstanceHolder a2;
        }
    }
}

