/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricMatrix
implements Matrix,
Densifiable {
    private final LowerTriangularMatrix case;
    private static final MatrixMathOperation false = new AutoParallelMatrixMathOperation();
    private final int enum;

    public int hashCode() {
        int a2 = 3;
        a2 = 17 * a2 + this.enum;
        a2 = 17 * a2 + (this.case != null ? this.case.hashCode() : 0);
        return a2;
    }

    public SymmetricMatrix(double[][] data) {
        this(new LowerTriangularMatrix(data));
    }

    @Override
    public SymmetricMatrix ZERO() {
        SymmetricMatrix a2 = new SymmetricMatrix((LowerTriangularMatrix)this.case.ZERO());
        return a2;
    }

    private static double[][] break(Matrix a2) {
        int a3 = a2.nRows();
        double[][] a4 = new double[a3][];
        for (int a5 = 0; a5 < a3; ++a5) {
            a4[a5] = new double[a5 + 1];
            for (int a6 = 0; a6 <= a5; ++a6) {
                a4[a5][a6] = a2.get(a5 + 1, a6 + 1);
            }
        }
        return a4;
    }

    public SymmetricMatrix(Matrix A2, boolean copyLower) {
        this(copyLower ? SymmetricMatrix.break(A2) : SymmetricMatrix.do(A2));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SymmetricMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        SymmetricMatrix a2 = (SymmetricMatrix)obj;
        if (this.enum != a2.enum) {
            return false;
        }
        return this.case == a2.case || this.case != null && this.case.equals(a2.case);
    }

    @Override
    public int nRows() {
        return this.enum;
    }

    public SymmetricMatrix(SymmetricMatrix S) {
        this(S.case.deepCopy());
    }

    private static double[][] do(Matrix a2) {
        int a3 = a2.nRows();
        double[][] a4 = new double[a3][];
        for (int a5 = 0; a5 < a3; ++a5) {
            a4[a5] = new double[a5 + 1];
            int a6 = 0;
            while (a6 <= a5) {
                a4[a5][a6] = a2.get(a5 + 1, a6 + 1);
                double[] dArray = a4[a5];
                int n = a6;
                dArray[n] = dArray[n] + a2.get(a6 + 1, a5 + 1);
                double[] dArray2 = a4[a5];
                int n2 = a6++;
                dArray2[n2] = dArray2[n2] / 2.0;
            }
        }
        return a4;
    }

    @Override
    public double get(int i, int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        if (i < j2) {
            return this.case.get(j2, i);
        }
        return this.case.get(i, j2);
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof SymmetricMatrix) {
            SymmetricMatrix a2 = new SymmetricMatrix((LowerTriangularMatrix)this.case.add(((SymmetricMatrix)that).case));
            return a2;
        }
        return false.add(this, that);
    }

    private SymmetricMatrix(LowerTriangularMatrix a2) {
        SymmetricMatrix a3;
        a3.enum = a2.nRows();
        a3.case = a2;
    }

    @Override
    public Matrix multiply(Matrix that) {
        return false.multiply((MatrixAccess)this, that);
    }

    @Override
    public Vector multiply(Vector v) {
        return false.multiply((MatrixAccess)this, v);
    }

    @Override
    public SymmetricMatrix deepCopy() {
        return new SymmetricMatrix(this);
    }

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        return this.getRow(j2);
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = this.case.toDense();
        for (int a3 = 1; a3 <= this.enum; ++a3) {
            for (int a4 = a3 + 1; a4 <= this.enum; ++a4) {
                a2.set(a3, a4, this.case.get(a4, a3));
            }
        }
        return a2;
    }

    @Override
    public int nCols() {
        return this.enum;
    }

    @Override
    public SymmetricMatrix t() {
        return new SymmetricMatrix(this);
    }

    public SymmetricMatrix(Matrix A2) {
        this(A2, false);
    }

    @Override
    public SymmetricMatrix ONE() {
        SymmetricMatrix a2 = new SymmetricMatrix((LowerTriangularMatrix)this.case.ONE());
        return a2;
    }

    @Override
    public void set(int row, int col, double value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        if (row < col) {
            this.case.set(col, row, value);
        } else {
            this.case.set(row, col, value);
        }
    }

    @Override
    public Vector getRow(int i) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, i);
        double[] a3 = this.case.getRow(i).toArray();
        double[] a4 = this.case.getColumn(i).toArray();
        double[] a5 = new double[this.enum];
        int a6 = 0;
        for (a2 = 0; a2 < i - 1; ++a2) {
            a5[a6++] = a3[a2];
        }
        for (a2 = i - 1; a2 < this.enum; ++a2) {
            a5[a6++] = a4[a2];
        }
        return new DenseVector(a5);
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof SymmetricMatrix) {
            SymmetricMatrix a2 = new SymmetricMatrix((LowerTriangularMatrix)this.case.minus(((SymmetricMatrix)that).case));
            return a2;
        }
        return false.minus(this, that);
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    @Override
    public SymmetricMatrix scaled(double scalar) {
        SymmetricMatrix a2 = new SymmetricMatrix(this.case.scaled(scalar));
        return a2;
    }

    @Override
    public SymmetricMatrix opposite() {
        return this.scaled(-1.0);
    }

    public SymmetricMatrix(int dim) {
        this(new LowerTriangularMatrix(dim));
    }
}

