/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseData;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.TriangularDataAccessUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayOperation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UpperTriangularMatrix
implements Matrix,
Densifiable {
    private static final MatrixMathOperation case = new AutoParallelMatrixMathOperation();
    private final MyDenseData false;
    private final int enum;

    private UpperTriangularMatrix(MyDenseData a2) {
        UpperTriangularMatrix a3;
        a3.false = a2;
        a3.enum = a2.nRows();
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 31 * a2 + (this.false != null ? this.false.hashCode() : 0);
        a2 = 31 * a2 + this.enum;
        return a2;
    }

    public UpperTriangularMatrix(Matrix A2) {
        this(A2.nRows());
        if (!DimensionCheck.isSquare(A2)) {
            throw new IllegalArgumentException("a upper triangular matrix must be square");
        }
        for (int a2 = 1; a2 <= this.enum; ++a2) {
            for (int a3 = a2; a3 <= this.enum; ++a3) {
                this.set(a2, a3, A2.get(a2, a3));
            }
        }
    }

    public UpperTriangularMatrix(UpperTriangularMatrix U) {
        this((MyDenseData)U.false.deepCopy());
    }

    @Override
    public UpperTriangularMatrix scaled(double scalar) {
        return new UpperTriangularMatrix((MyDenseData)this.false.scaled(scalar));
    }

    @Override
    public DenseMatrix toDense() {
        double[] a2 = this.false.asArray();
        int a3 = 0;
        double[] a4 = new double[this.nRows() * this.nCols()];
        int a5 = 1;
        int a6 = 0;
        while (a6 < a4.length) {
            for (int a7 = 0; a7 <= this.nCols() - a5; ++a7) {
                a4[a6 + a7] = a2[a3++];
            }
            a6 += this.nCols() + 1;
            ++a5;
        }
        return new DenseMatrix(a4, this.nRows(), this.nCols());
    }

    @Override
    public int nRows() {
        return this.enum;
    }

    @Override
    public Vector getRow(int i) {
        if (i < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (i > this.nRows()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = new double[this.nCols()];
        int a3 = (i - 1) * this.nCols();
        if (i >= 3) {
            a3 -= (i - 1) * (i - 2) >> 1;
        }
        int a4 = i - 1;
        int a5 = this.nCols() - a4;
        System.arraycopy(this.false.asArray(), a3, a2, a4, a5);
        return new DenseVector(a2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!UpperTriangularMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        UpperTriangularMatrix a2 = (UpperTriangularMatrix)obj;
        if (this.enum != a2.enum) {
            return false;
        }
        return this.false == a2.false || this.false != null && this.false.equals(a2.false);
    }

    @Override
    public double get(int i, int j2) throws MatrixAccessException {
        return this.false.get(i, j2);
    }

    UpperTriangularMatrix(double[] a2, int a3) {
        a4(new MyDenseData(a2, a3));
        UpperTriangularMatrix a4;
    }

    public UpperTriangularMatrix(int dim) {
        this(new MyDenseData(dim));
    }

    @Override
    public UpperTriangularMatrix opposite() {
        return this.scaled(-1.0);
    }

    public UpperTriangularMatrix(double[][] data) {
        this(data[0].length);
        for (int a2 = 1; a2 <= this.enum; ++a2) {
            if (data[a2 - 1].length == this.enum - a2 + 1) continue;
            throw new IllegalArgumentException("data set is not upper triangular");
        }
        double[] a3 = this.false.asArray();
        int a4 = 0;
        for (int a5 = 0; a5 < this.enum; ++a5) {
            int a6 = this.enum - a5;
            for (int a7 = 0; a7 < a6; ++a7) {
                a3[a4++] = data[a5][a7];
            }
        }
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (!(that instanceof UpperTriangularMatrix)) {
            return case.multiply((MatrixAccess)this, that);
        }
        MyDenseData a2 = this.false;
        MyDenseData a3 = ((UpperTriangularMatrix)that).false;
        UpperTriangularMatrix a4 = new UpperTriangularMatrix(this.enum);
        MyDenseData a5 = a4.false;
        for (int a6 = 1; a6 <= this.enum; ++a6) {
            for (int a7 = a6; a7 <= this.enum; ++a7) {
                double a8 = 0.0;
                for (int a9 = a6; a9 <= a7; ++a9) {
                    a8 += a2.get(a6, a9) * a3.get(a9, a7);
                }
                a5.set(a6, a7, a8);
            }
        }
        return a4;
    }

    @Override
    public Vector getColumn(int j2) {
        if (j2 < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (j2 > this.nCols()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = this.false.asArray();
        double[] a3 = new double[this.nRows()];
        int a4 = 0;
        int a5 = j2 - 1;
        while (a4 < j2) {
            a3[a4] = a2[a5];
            a5 += this.nCols() - ++a4;
        }
        return new DenseVector(a3);
    }

    @Override
    public int nCols() {
        return this.enum;
    }

    @Override
    public UpperTriangularMatrix deepCopy() {
        return new UpperTriangularMatrix(this);
    }

    @Override
    public void set(int i, int j2, double value) throws MatrixAccessException {
        this.false.set(i, j2, value);
    }

    @Override
    public UpperTriangularMatrix ONE() {
        UpperTriangularMatrix a2 = new UpperTriangularMatrix(this.enum);
        for (int a3 = 1; a3 <= this.enum; ++a3) {
            a2.set(a3, a3, 1.0);
        }
        return a2;
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof UpperTriangularMatrix) {
            return new UpperTriangularMatrix((MyDenseData)this.false.minus(((UpperTriangularMatrix)that).false));
        }
        return case.minus(this, that);
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof UpperTriangularMatrix) {
            return new UpperTriangularMatrix((MyDenseData)this.false.add(((UpperTriangularMatrix)that).false));
        }
        return case.add(this, that);
    }

    @Override
    public UpperTriangularMatrix ZERO() {
        UpperTriangularMatrix a2 = new UpperTriangularMatrix(this.enum);
        return a2;
    }

    @Override
    public LowerTriangularMatrix t() {
        double[] a2 = new double[this.false.asArray().length];
        double[] a3 = this.false.asArray();
        int a4 = 0;
        for (int a5 = 0; a5 < this.nCols(); ++a5) {
            int a6 = 0;
            int a7 = 0;
            while (a6 <= a5) {
                a2[a4++] = a3[a5 + a7];
                a7 += this.nRows() - ++a6;
            }
        }
        return new LowerTriangularMatrix(a2, this.enum);
    }

    @Override
    public Vector multiply(Vector v) {
        return case.multiply((MatrixAccess)this, v);
    }

    private static final class MyDenseData
    extends DenseData {
        @Override
        public int position(int nRows, int nCols, int i, int j2) {
            if (i <= j2) {
                int a2 = (((nCols << 1) - i + 2) * (i - 1) >> 1) + (j2 - i);
                return a2;
            }
            return -1;
        }

        private MyDenseData(double[] a2, int a3) {
            super(a2, a3, a3);
            MyDenseData a4;
        }

        @Override
        protected MyDenseData newInstance(double[] data, int nRows, int nCols, DoubleArrayOperation operation) {
            return new MyDenseData(data, nRows, operation);
        }

        private MyDenseData(int a2) {
            a3(new double[TriangularDataAccessUtils.dataLength(a2)], a2);
            MyDenseData a3;
        }

        private MyDenseData(double[] a2, int a3, DoubleArrayOperation a4) {
            super(a2, a3, a3, a4);
            MyDenseData a5;
        }
    }
}

