/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.datastructure.Table;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CSRSparseMatrix
implements SparseMatrix {
    private final int int;
    private double[] true = null;
    private static final ParallelExecutor do;
    private int[] long = null;
    private int super = 0;
    private int[] char = null;
    private static final int new = 10000;
    private static final int const = 100;
    private final int case;
    private static final MatrixMathOperation false;
    private static final int enum = 5000;

    static {
        false = new AutoParallelMatrixMathOperation();
        do = new ParallelExecutor(CSRSparseMatrix.class.getSimpleName());
    }

    private static List<SparseMatrix.Entry> do(int[] a2, int[] a3, double[] a4) {
        ArgumentAssertion.assertTrue(a3.length == a4.length && a2.length == a4.length, "input arrays size mismatch", new Object[0]);
        int a5 = a4.length;
        ArrayList<SparseMatrix.Entry> a6 = new ArrayList<SparseMatrix.Entry>(a5);
        for (int a7 = 0; a7 < a5; ++a7) {
            a6.add(new SparseMatrix.Entry(new MatrixCoordinate(a2[a7], a3[a7]), a4[a7]));
        }
        return a6;
    }

    private void do(CheckForKeptValue a2) {
        CSRSparseMatrix a3;
        int a4 = 0;
        for (int a5 = 0; a5 < a3.case; ++a5) {
            a3.char[a5] = a4;
            for (int a6 = a3.char[a5]; a6 < a3.char[a5 + 1]; ++a6) {
                if (!a2.toKeep(a3.true[a6])) continue;
                a3.true[a4] = a3.true[a6];
                a3.long[a4] = a3.long[a6];
                ++a4;
            }
        }
        a3.char[a3.case] = a4;
        a3.true = Arrays.copyOf(a3.true, a4);
        a3.long = Arrays.copyOf(a3.long, a4);
        a3.super = a4;
    }

    public CSRSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols, entries, false);
    }

    @Override
    public int nCols() {
        return this.int;
    }

    public CSRSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] values) {
        this(nRows, nCols, CSRSparseMatrix.do(rowIndices, columnIndices, values));
    }

    private void break() {
        CSRSparseMatrix a2;
        if (a2.super == 0) {
            return;
        }
        if (a2.super >= 5000) {
            try {
                do.forLoop(1, a2.case + 1, new LoopBody(){
                    {
                        2 a2;
                    }

                    @Override
                    public void run(int i) throws Exception {
                        int a2 = CSRSparseMatrix.this.char[i - 1];
                        int a3 = CSRSparseMatrix.this.char[i];
                        CSRSparseMatrix.do(CSRSparseMatrix.this.long, CSRSparseMatrix.this.true, a2, a3);
                    }
                });
            }
            catch (MultipleExecutionException a3) {
                a2.t().t();
            }
        } else {
            a2.t().t();
        }
    }

    @Override
    public SparseVector getRow(int i) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        int a2 = this.char[i - 1];
        int a3 = this.char[i];
        LinkedList<SparseVector.Entry> a4 = new LinkedList<SparseVector.Entry>();
        for (int a5 = a2; a5 < a3; ++a5) {
            SparseVector.Entry a6 = new SparseVector.Entry(this.long[a5], this.true[a5]);
            a4.add(a6);
        }
        SparseVector a7 = new SparseVector(this.int, a4, true);
        return a7;
    }

    @Override
    public CSRSparseMatrix t() {
        int a2;
        CSRSparseMatrix a3 = new CSRSparseMatrix(this.int, this.case);
        double[] a4 = new double[this.true.length];
        int[] a5 = new int[this.long.length];
        int[] a6 = new int[this.int + 1];
        for (a2 = 0; a2 < this.long.length; ++a2) {
            int n = this.long[a2];
            a6[n] = a6[n] + 1;
        }
        a6 = DoubleUtils.cumsum(a6);
        a3.char = (int[])a6.clone();
        for (a2 = 1; a2 <= this.case; ++a2) {
            for (int a7 = this.char[a2 - 1]; a7 < this.char[a2]; ++a7) {
                int n = this.long[a7] - 1;
                a6[n] = a6[n] + 1;
                a5[a] = a2;
                a4[a] = this.true[a7];
            }
        }
        a3.true = a4;
        a3.long = a5;
        a3.super = this.super;
        return a3;
    }

    private static List<SparseMatrix.Entry> do(Matrix a2) {
        ArrayList<SparseMatrix.Entry> a3 = new ArrayList<SparseMatrix.Entry>();
        for (int a4 = 1; a4 <= a2.nRows(); ++a4) {
            for (int a5 = 1; a5 <= a2.nCols(); ++a5) {
                double a6 = a2.get(a4, a5);
                if (a6 == 0.0) continue;
                a3.add(new SparseMatrix.Entry(new MatrixCoordinate(a4, a5), a6));
            }
        }
        return a3;
    }

    @Override
    public CSRSparseMatrix deepCopy() {
        return new CSRSparseMatrix(this);
    }

    @Override
    public CSRSparseMatrix ONE() {
        int a2 = Math.min(this.case, this.int);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new CSRSparseMatrix(this.case, this.int, a4, a5, a3);
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.do((CSRSparseMatrix)that, 1.0);
        }
        return false.add(this, that);
    }

    @Override
    public CSRSparseMatrix ZERO() {
        return new CSRSparseMatrix(this.case, this.int);
    }

    @Override
    public CSRSparseMatrix scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new CSRSparseMatrix(this.case, this.int);
        }
        CSRSparseMatrix a2 = new CSRSparseMatrix(this);
        int a3 = 0;
        while (a3 < a2.true.length) {
            int n = a3++;
            a2.true[n] = a2.true[n] * c2;
        }
        return a2;
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.break((CSRSparseMatrix)that);
        }
        return false.multiply((MatrixAccess)this, that);
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        int a2 = this.char[row - 1];
        int a3 = this.char[row];
        int a4 = 0;
        for (a4 = a2; a4 < a3 && this.long[a4] < col; ++a4) {
        }
        if (a4 != a3 && this.long[a4] == col) {
            if (value != 0.0) {
                this.true[a4] = value;
            } else {
                double[] a5 = this.true;
                this.true = new double[a5.length - 1];
                System.arraycopy(a5, 0, this.true, 0, a4);
                System.arraycopy(a5, a4 + 1, this.true, a4, this.true.length - a4);
                int[] a6 = this.long;
                this.long = new int[a6.length - 1];
                System.arraycopy(a6, 0, this.long, 0, a4);
                System.arraycopy(a6, a4 + 1, this.long, a4, this.long.length - a4);
                int a7 = row;
                while (a7 < this.char.length) {
                    int n = a7++;
                    this.char[n] = this.char[n] - 1;
                }
                --this.super;
            }
        } else {
            if (value == 0.0) {
                return;
            }
            double[] a8 = this.true;
            this.true = new double[a8.length + 1];
            System.arraycopy(a8, 0, this.true, 0, a4);
            System.arraycopy(a8, a4, this.true, a4 + 1, a8.length - a4);
            this.true[a4] = value;
            int[] a9 = this.long;
            this.long = new int[a9.length + 1];
            System.arraycopy(a9, 0, this.long, 0, a4);
            System.arraycopy(a9, a4, this.long, a4 + 1, a9.length - a4);
            this.long[a4] = col;
            int a10 = row;
            while (a10 < this.char.length) {
                int n = a10++;
                this.char[n] = this.char[n] + 1;
            }
            ++this.super;
        }
    }

    private CSRSparseMatrix break(final CSRSparseMatrix a2) {
        int a3;
        int a4;
        CSRSparseMatrix a5;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a5, a2);
        final int a6 = a2.int;
        final Row[] a7 = new Row[a5.case];
        LoopBody a8 = new LoopBody(){

            @Override
            public void run(int i) throws Exception {
                Scatter a22 = new Scatter(a6);
                for (int a3 = CSRSparseMatrix.this.char[i - 1]; a3 < CSRSparseMatrix.this.char[i]; ++a3) {
                    a22.do(a2, CSRSparseMatrix.this.long[a3], CSRSparseMatrix.this.true[a3]);
                }
                a7[i - 1] = a22.do();
            }
            {
                3 a22;
            }
        };
        try {
            do.conditionalForLoop(a5.do(a2), 1, a5.case + 1, a8);
        }
        catch (MultipleExecutionException a9) {
            try {
                for (a4 = 1; a4 <= a5.case; ++a4) {
                    a8.run(a4);
                }
            }
            catch (Exception a10) {
                throw new RuntimeException("CSRSparseMatrix multiply failed", a10);
            }
        }
        CSRSparseMatrix a11 = new CSRSparseMatrix(a5.case, a2.int);
        a4 = 0;
        for (a3 = 0; a3 < a5.case; ++a3) {
            a11.char[a3] = a4;
            a4 += a7[a3].false;
        }
        a11.char[a5.case] = a4;
        a11.super = a4;
        a11.true = new double[a4];
        a11.long = new int[a4];
        int a12 = 0;
        for (a3 = 0; a3 < a5.case; ++a3) {
            a12 += a7[a3].do(a11.long, a11.true, a12);
        }
        return a11;
    }

    private void do() {
        CSRSparseMatrix a2;
        a2.do(new CheckForKeptValue(){
            {
                5 a2;
            }

            @Override
            public boolean toKeep(double value) {
                return Double.compare(0.0, value) != 0;
            }
        });
    }

    public CSRSparseMatrix(int nRows, int nCols) {
        this.case = nRows;
        this.int = nCols;
        this.super = 0;
        this.true = new double[0];
        this.long = new int[0];
        this.char = new int[nRows + 1];
    }

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    @Override
    public CSRSparseMatrix opposite() {
        return this.scaled(-1.0);
    }

    private CSRSparseMatrix do(final CSRSparseMatrix a2, final double a3) {
        int a4;
        int a5;
        CSRSparseMatrix a6;
        DimensionCheck.throwIfDifferentDimension(a6, a2);
        final Row[] a7 = new Row[a6.case];
        LoopBody a8 = new LoopBody(){
            {
                1 a22;
            }

            @Override
            public void run(int i) throws Exception {
                Scatter a22 = new Scatter(CSRSparseMatrix.this.int);
                a22.do(CSRSparseMatrix.this, i, 1.0);
                a22.do(a2, i, a3);
                a7[i - 1] = a22.do();
            }
        };
        try {
            do.conditionalForLoop(a6.do(a2), 1, a6.case + 1, a8);
        }
        catch (MultipleExecutionException a9) {
            for (a5 = 1; a5 <= a6.case; ++a5) {
                try {
                    a8.run(a5);
                    continue;
                }
                catch (Exception a10) {
                    throw new RuntimeException("CSRSparseMatrix add failed", a10);
                }
            }
        }
        CSRSparseMatrix a11 = new CSRSparseMatrix(a6.case, a6.int);
        a5 = 0;
        for (a4 = 0; a4 < a6.case; ++a4) {
            a11.char[a4] = a5;
            a5 += a7[a4].false;
        }
        a11.char[a6.case] = a5;
        a11.super = a5;
        a11.true = new double[a5];
        a11.long = new int[a5];
        for (a4 = 0; a4 < a6.case; ++a4) {
            a7[a4].do(a11.long, a11.true, a11.char[a4]);
        }
        return a11;
    }

    public CSRSparseMatrix(Matrix A2) {
        this(A2.nRows(), A2.nCols(), CSRSparseMatrix.do(A2));
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 47 * a2 + Arrays.hashCode(this.char);
        a2 = 47 * a2 + Arrays.hashCode(this.long);
        a2 = 47 * a2 + Arrays.hashCode(this.true);
        a2 = 47 * a2 + this.case;
        a2 = 47 * a2 + this.int;
        return a2;
    }

    private boolean do(CSRSparseMatrix a2) {
        CSRSparseMatrix a3;
        return a3.super + a2.super > 10000;
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.do((CSRSparseMatrix)that, -1.0);
        }
        return false.minus(this, that);
    }

    public CSRSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries, boolean areEntriesSorted) {
        this(nRows, nCols);
        this.char = !areEntriesSorted ? SparseMatrixUtils.sortInRowColumnOrder(entries, nRows, nCols, true, true) : DoubleUtils.cumsum(SparseMatrixUtils.countEntriesInEachRow(entries, nRows));
        this.super = entries.size();
        this.true = new double[this.super];
        this.long = new int[this.super];
        int a2 = 0;
        for (SparseMatrix.Entry a3 : entries) {
            this.true[a2] = a3.value;
            this.long[a2] = a3.coordinates.j;
            ++a2;
        }
    }

    private static void do(int[] a2, double[] a3, int a4, int a5) {
        Object[] a6 = new IndexedValue[a5 - a4];
        int a7 = a4;
        int a8 = 0;
        while (a7 < a5) {
            a6[a8] = new IndexedValue(a2[a7], a3[a7]);
            ++a7;
            ++a8;
        }
        Arrays.sort(a6);
        a7 = a4;
        a8 = 0;
        while (a7 < a5) {
            a2[a7] = ((IndexedValue)a6[a8]).enum;
            a3[a7] = ((IndexedValue)a6[a8]).false;
            ++a7;
            ++a8;
        }
    }

    @Override
    public double get(int i, int j2) {
        DimensionCheck.throwIfInvalidRow(this, i);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        int a2 = this.char[i - 1];
        int a3 = this.char[i];
        int a4 = 0;
        for (a4 = a2; a4 < a3 && this.long[a4] != j2; ++a4) {
        }
        return a4 == a3 ? 0.0 : this.true[a4];
    }

    @Override
    public int nRows() {
        return this.case;
    }

    private static int do(int[] a2, double[] a3) {
        int a4 = 0;
        for (int a5 = 0; a5 < a3.length; ++a5) {
            if (Double.compare(0.0, a3[a5]) == 0) continue;
            if (a4 != a5) {
                a3[a4] = a3[a5];
                a2[a4] = a2[a5];
            }
            ++a4;
        }
        return a4;
    }

    @Override
    public List<SparseMatrix.Entry> getEntrytList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        for (int a3 = 1; a3 <= this.case; ++a3) {
            for (int a4 = this.char[a3 - 1]; a4 < this.char[a3]; ++a4) {
                a2.add(new SparseMatrix.Entry(new MatrixCoordinate(a3, this.long[a4]), this.true[a4]));
            }
        }
        return a2;
    }

    @Override
    public SparseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.case);
        block0: for (int a3 = 1; a3 <= this.case; ++a3) {
            int a4 = this.char[a3 - 1];
            int a5 = this.char[a3];
            for (int a6 = a4; a6 < a5; ++a6) {
                if (this.long[a6] != j2) continue;
                a2.set(a3, this.true[a6]);
                continue block0;
            }
        }
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        CSRSparseMatrix a2 = (CSRSparseMatrix)obj;
        if (this.case != a2.case) {
            return false;
        }
        if (this.int != a2.int) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    @Override
    public Vector multiply(final Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        final double[] a2 = new double[this.case];
        try {
            do.conditionalForLoop(this.case >= 100, 1, this.case + 1, new LoopBody(){

                @Override
                public void run(int i) throws Exception {
                    a2[i - 1] = CSRSparseMatrix.this.getRow(i).innerProduct(v);
                }
                {
                    4 a22;
                }
            });
        }
        catch (MultipleExecutionException a3) {
            for (int a4 = 1; a4 <= this.case; ++a4) {
                a2[a4 - 1] = this.getRow(a4).innerProduct(v);
            }
        }
        Vector a5 = v instanceof SparseVector ? new SparseVector(a2) : new DenseVector(a2);
        return a5;
    }

    public CSRSparseMatrix(CSRSparseMatrix that) {
        this.case = that.nRows();
        this.int = that.nCols();
        this.super = that.super;
        this.true = (double[])that.true.clone();
        this.long = (int[])that.long.clone();
        this.char = (int[])that.char.clone();
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.case, this.int);
        for (int a3 = 1; a3 <= this.case; ++a3) {
            for (int a4 = this.char[a3 - 1]; a4 < this.char[a3]; ++a4) {
                a2.set(a3, this.long[a4], this.true[a4]);
            }
        }
        return a2;
    }

    @Override
    public int nNonZeros() {
        return this.super;
    }

    private static interface CheckForKeptValue {
        public boolean toKeep(double var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Row {
        private final double[] case;
        private final int false;
        private final int[] enum;

        private int do(int[] a2, double[] a3, int a4) {
            Row a5;
            System.arraycopy(a5.enum, 0, a2, a4, a5.false);
            System.arraycopy(a5.case, 0, a3, a4, a5.false);
            return a5.false;
        }

        private Row(int[] a2, double[] a3, int a4) {
            Row a5;
            a5.enum = a2;
            a5.case = a3;
            a5.false = a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Scatter {
        private final int[] const;
        private final boolean[] case;
        private final double[] false;
        private int enum;

        private Scatter(int a2) {
            Scatter a3;
            a3.case = new boolean[a2 + 1];
            a3.false = new double[a2 + 1];
            a3.const = new int[a2];
            a3.enum = 0;
        }

        private void do(CSRSparseMatrix a2, int a3, double a4) {
            int a5 = a2.char[a3 - 1];
            int a6 = a2.char[a3];
            for (int a7 = a5; a7 < a6; ++a7) {
                Scatter a8;
                int a9 = a2.long[a7];
                if (!a8.case[a9]) {
                    a8.case[a9] = true;
                    a8.const[a8.enum++] = a9;
                }
                int n = a9;
                a8.false[n] = a8.false[n] + a4 * a2.true[a7];
            }
        }

        private Row do() {
            int a2;
            Scatter a3;
            int[] a4 = Arrays.copyOf(a3.const, a3.enum);
            double[] a5 = new double[a3.enum];
            for (a2 = 0; a2 < a3.enum; ++a2) {
                a5[a2] = a3.false[a3.const[a2]];
            }
            a2 = CSRSparseMatrix.do(a4, a5);
            if (a3.enum != a2) {
                a4 = Arrays.copyOf(a4, a2);
                a5 = Arrays.copyOf(a5, a2);
            }
            CSRSparseMatrix.do(a4, a5, 0, a2);
            return new Row(a4, a5, a2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class IndexedValue
    implements Comparable<IndexedValue> {
        private final double false;
        private final int enum;

        private IndexedValue(int a2, double a3) {
            IndexedValue a4;
            a4.enum = a2;
            a4.false = a3;
        }

        @Override
        public int compareTo(IndexedValue o) {
            return this.enum - o.enum;
        }
    }
}

