/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.datastructure.Table;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DOKSparseMatrix
implements SparseMatrix {
    private static final MatrixMathOperation const = new AutoParallelMatrixMathOperation();
    private final int case;
    private final int false;
    private HashMap<MatrixCoordinate, Double> enum;

    public DOKSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols);
        this.enum = new HashMap(entries.size());
        for (SparseMatrix.Entry a2 : entries) {
            Double a3 = this.do(a2.coordinates.i, a2.coordinates.j, a2.value);
            ArgumentAssertion.assertTrue(a3 == null, "repeated entry at coordinates %s", a2.coordinates);
        }
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 71 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        a2 = 71 * a2 + this.false;
        a2 = 71 * a2 + this.case;
        return a2;
    }

    @Override
    public DOKSparseMatrix ZERO() {
        return new DOKSparseMatrix(this.false, this.case);
    }

    @Override
    public SparseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.false);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            if (a3.getKey().j != j2) continue;
            a2.set(a3.getKey().i, a3.getValue());
        }
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        DOKSparseMatrix a2 = (DOKSparseMatrix)obj;
        if (this.false != a2.false) {
            return false;
        }
        if (this.case != a2.case) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    @Override
    public DOKSparseMatrix t() {
        DOKSparseMatrix a2 = new DOKSparseMatrix(this.case, this.false);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            MatrixCoordinate a4 = a3.getKey();
            a2.set(a4.j, a4.i, a3.getValue());
        }
        return a2;
    }

    @Override
    public DOKSparseMatrix deepCopy() {
        return new DOKSparseMatrix(this);
    }

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    @Override
    public DOKSparseMatrix ONE() {
        int a2 = Math.min(this.false, this.case);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new DOKSparseMatrix(this.false, this.case, a4, a5, a3);
    }

    public DOKSparseMatrix(DOKSparseMatrix that) {
        this(that.false, that.case);
        this.enum = new HashMap<MatrixCoordinate, Double>(that.enum);
    }

    @Override
    public DOKSparseMatrix scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new DOKSparseMatrix(this.false, this.case);
        }
        DOKSparseMatrix a2 = new DOKSparseMatrix(this.false, this.case);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            a2.enum.put(a3.getKey(), c2 * a3.getValue());
        }
        return a2;
    }

    @Override
    public int nRows() {
        return this.false;
    }

    @Override
    public int nCols() {
        return this.case;
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        int a2 = that.nCols();
        Matrix a3 = that instanceof SparseMatrix ? new DOKSparseMatrix(this.false, a2) : new DenseMatrix(this.false, a2);
        for (Map.Entry<MatrixCoordinate, Double> a4 : this.enum.entrySet()) {
            int a5 = a4.getKey().i;
            int a6 = a4.getKey().j;
            double a7 = a4.getValue();
            for (int a8 = 1; a8 <= a2; ++a8) {
                a3.set(a5, a8, a3.get(a5, a8) + a7 * that.get(a6, a8));
            }
        }
        return a3;
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof DOKSparseMatrix) {
            return this.do((DOKSparseMatrix)that, 1);
        }
        return const.add(this, that);
    }

    @Override
    public double get(int i, int j2) {
        DimensionCheck.throwIfInvalidRow(this, i);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        Double a2 = this.enum.get(new MatrixCoordinate(i, j2));
        return a2 == null ? 0.0 : a2;
    }

    public DOKSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] value) {
        this(nRows, nCols);
        this.enum = new HashMap(value.length);
        ArgumentAssertion.assertTrue(rowIndices.length == columnIndices.length && rowIndices.length == value.length, "input arrays size mismatch", new Object[0]);
        for (int a2 = 0; a2 < rowIndices.length; ++a2) {
            this.do(rowIndices[a2], columnIndices[a2], value[a2]);
        }
    }

    @Override
    public int nNonZeros() {
        return this.enum.size();
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof DOKSparseMatrix) {
            return this.do((DOKSparseMatrix)that, -1);
        }
        return const.minus(this, that);
    }

    @Override
    public void set(int row, int col, double value) {
        this.do(row, col, value);
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.false, this.case);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            MatrixCoordinate a4 = a3.getKey();
            a2.set(a4.i, a4.j, a3.getValue());
        }
        return a2;
    }

    @Override
    public List<SparseMatrix.Entry> getEntrytList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            a2.add(new SparseMatrix.Entry(a3.getKey(), a3.getValue()));
        }
        SparseMatrixUtils.sortInRowColumnOrder(a2, this.false, this.case, false, false);
        return a2;
    }

    @Override
    public SparseVector getRow(int i) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i);
        SparseVector a2 = new SparseVector(this.case);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            if (a3.getKey().i != i) continue;
            a2.set(a3.getKey().j, a3.getValue());
        }
        return a2;
    }

    public DOKSparseMatrix(int nRows, int nCols) {
        this.false = nRows;
        this.case = nCols;
        this.enum = new HashMap(0);
    }

    private DOKSparseMatrix do(DOKSparseMatrix a2, int a3) {
        DOKSparseMatrix a4;
        DimensionCheck.throwIfDifferentDimension(a4, a2);
        DOKSparseMatrix a5 = new DOKSparseMatrix(a4);
        for (Map.Entry<MatrixCoordinate, Double> a6 : a2.enum.entrySet()) {
            MatrixCoordinate a7 = a6.getKey();
            Double a8 = a5.enum.get(a7);
            a8 = a8 == null ? (double)a3 * a6.getValue() : a8 + (double)a3 * a6.getValue();
            if (Double.compare(0.0, a8) != 0) {
                a5.enum.put(a7, a8);
                continue;
            }
            a5.enum.remove(a7);
        }
        return a5;
    }

    @Override
    public Vector multiply(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        Vector a2 = v instanceof SparseVector ? new SparseVector(this.false) : new DenseVector(this.false);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            double a4 = a3.getValue() * v.get(a3.getKey().j);
            int a5 = a3.getKey().i;
            a2.set(a5, a2.get(a5) + a4);
        }
        return a2;
    }

    private Double do(int a2, int a3, double a4) {
        DOKSparseMatrix a5;
        DimensionCheck.throwIfInvalidRow(a5, a2);
        DimensionCheck.throwIfInvalidColumn(a5, a3);
        if (Double.compare(0.0, a4) != 0) {
            return a5.enum.put(new MatrixCoordinate(a2, a3), a4);
        }
        return a5.enum.remove(new MatrixCoordinate(a2, a3));
    }

    @Override
    public DOKSparseMatrix opposite() {
        return this.scaled(-1.0);
    }
}

