/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseStructure;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.Real;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SparseVector
implements Vector,
SparseStructure,
Iterable<Entry> {
    private final LinkedList<Entry> false;
    private final int enum;

    @Override
    public double innerProduct(Vector that) {
        if (that instanceof SparseVector) {
            return this.innerProduct((SparseVector)that);
        }
        return this.final(that);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        if (!SparseVector.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Vector)obj, 0.0);
        }
        SparseVector a2 = (SparseVector)obj;
        if (this.enum != a2.enum) {
            return false;
        }
        return this.false == a2.false || this.false != null && this.do(this.false, a2.false);
    }

    @Override
    public int size() {
        return this.enum;
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        for (Entry a3 : this.false) {
            a2.append(a3.toString()).append("\n");
        }
        return a2.toString();
    }

    @Override
    public SparseVector opposite() {
        return this.scaled(-1.0);
    }

    public SparseVector(int size, List<Entry> entries) {
        this(size, entries, false);
    }

    @Override
    public double innerProduct(SparseVector that) {
        Entry a2;
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double a3 = 0.0;
        java.util.Iterator a4 = this.false.iterator();
        java.util.Iterator a5 = that.false.iterator();
        Entry a6 = a4.hasNext() ? (Entry)a4.next() : null;
        Entry entry = a2 = a5.hasNext() ? (Entry)a5.next() : null;
        while (a6 != null && a2 != null) {
            if (a6.enum < a2.enum) {
                a6 = a4.hasNext() ? (Entry)a4.next() : null;
                continue;
            }
            if (a6.enum > a2.enum) {
                a2 = a5.hasNext() ? (Entry)a5.next() : null;
                continue;
            }
            a3 += a6.false * a2.false;
            a6 = a4.hasNext() ? (Entry)a4.next() : null;
            a2 = a5.hasNext() ? (Entry)a5.next() : null;
        }
        return a3;
    }

    @Override
    public void set(int index, double value) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, index);
        ListIterator<Entry> a2 = this.false.listIterator();
        while (a2.hasNext()) {
            Entry a3 = (Entry)a2.next();
            if (a3.enum == index) {
                if (Double.compare(0.0, value) != 0) {
                    a3.false = value;
                } else {
                    a2.remove();
                }
                return;
            }
            if (a3.enum <= index) continue;
            if (Double.compare(0.0, value) != 0) {
                a2.previous();
                a2.add(new Entry(index, value));
            }
            return;
        }
        if (Double.compare(0.0, value) != 0) {
            this.false.addLast(new Entry(index, value));
        }
    }

    @Override
    public Vector pow(double c2) {
        double a2 = Math.pow(0.0, c2);
        if (Double.compare(0.0, a2) != 0) {
            double[] a3 = DoubleUtils.rep(a2, this.enum);
            for (Entry a4 : this.false) {
                a3[((Entry)a4).enum - 1] = Math.pow(a4.false, c2);
            }
            return new DenseVector(a3);
        }
        LinkedList<Entry> a5 = new LinkedList<Entry>();
        for (Entry a6 : this.false) {
            a5.add(new Entry(a6.enum, Math.pow(a6.false, c2)));
        }
        return new SparseVector(this.enum, a5);
    }

    @Override
    public SparseVector scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new SparseVector(this.enum);
        }
        LinkedList<Entry> a2 = new LinkedList<Entry>();
        for (Entry a3 : this.false) {
            a2.add(new Entry(a3.enum, c2 * a3.false));
        }
        return new SparseVector(this.enum, a2);
    }

    private boolean do(LinkedList<Entry> a2, LinkedList<Entry> a3) {
        SparseVector a4;
        if (a4.false.size() != a4.false.size()) {
            return false;
        }
        java.util.Iterator a5 = a2.iterator();
        java.util.Iterator a6 = a3.iterator();
        while (a5.hasNext()) {
            Entry a7 = (Entry)a5.next();
            Entry a8 = (Entry)a6.next();
            if (a7.enum != a8.enum) {
                return false;
            }
            if (a7.false == a8.false) continue;
            return false;
        }
        return true;
    }

    private static List<Entry> do(int a2, int[] a3, double[] a4) {
        ArgumentAssertion.assertTrue(a3.length == a4.length, "sizes of input arrays mismatch", new Object[0]);
        ArrayList<Entry> a5 = new ArrayList<Entry>();
        for (int a6 = 0; a6 < a4.length; ++a6) {
            if (a3[a6] < 1 || a3[a6] > a2) {
                throw new IndexOutOfBoundsException("out-of-range index: " + a3[a6]);
            }
            a5.add(new Entry(a3[a6], a4[a6]));
        }
        return a5;
    }

    SparseVector(int a2, List<Entry> a3, boolean a4) {
        List<Entry> a5;
        SparseVector a6;
        a6.enum = a2;
        if (!a4) {
            a5 = new ArrayList<Entry>(a3);
            Collections.sort(a5, Entry.Comparator.INSTANCE);
        } else {
            a5 = a3;
        }
        a6.false = new LinkedList();
        int a7 = 0;
        for (Entry a8 : a5) {
            if (a7 >= a8.enum) {
                throw new IllegalArgumentException("duplicated indices: " + a8.enum);
            }
            a7 = a8.enum;
            a6.false.add(a8);
        }
    }

    private SparseVector(int a2, LinkedList<Entry> a3) {
        SparseVector a4;
        a4.enum = a2;
        a4.false = a3;
    }

    private double final(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        double a4 = 0.0;
        for (Entry a5 : a3.false) {
            a4 += a5.false * a2.get(a5.enum);
        }
        return a4;
    }

    private SparseVector byte(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        SparseVector a4 = new SparseVector(a3);
        for (Entry a5 : a4.false) {
            a4.set(a5.enum, a5.false * a2.get(a5.enum));
        }
        return a4;
    }

    @Override
    public double[] toArray() {
        double[] a2 = new double[this.enum];
        for (Entry a3 : this.false) {
            a2[((Entry)a3).enum - 1] = a3.false;
        }
        return a2;
    }

    @Override
    public Vector add(Vector that) {
        if (that instanceof SparseVector) {
            return this.add((SparseVector)that);
        }
        return this.break(that);
    }

    @Override
    public SparseVector multiply(Vector that) {
        if (that instanceof SparseVector) {
            return this.multiply((SparseVector)that);
        }
        return this.byte(that);
    }

    public SparseVector(SparseVector that) {
        this(that.enum);
        for (Entry a2 : that.false) {
            this.false.add(new Entry(a2.enum, a2.false));
        }
    }

    @Override
    public SparseVector minus(SparseVector that) {
        return this.do(that, -1);
    }

    public SparseVector(double ... v) {
        this.enum = v.length;
        this.false = new LinkedList();
        for (int a2 = 0; a2 < this.enum; ++a2) {
            double a3 = v[a2];
            if (a3 == 0.0) continue;
            Entry a4 = new Entry(a2 + 1, a3);
            this.false.add(a4);
        }
    }

    @Override
    public Vector divide(Vector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        SparseVector a2 = new SparseVector(this);
        for (Entry a3 : a2.false) {
            a2.set(a3.enum, a3.false / that.get(a3.enum));
        }
        return a2;
    }

    @Override
    public int nNonZeros() {
        return this.false.size();
    }

    public SparseVector multiply(SparseVector that) {
        Entry a2;
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        LinkedList<Entry> a3 = new LinkedList<Entry>();
        java.util.Iterator a4 = this.false.iterator();
        java.util.Iterator a5 = that.false.iterator();
        Entry a6 = a4.hasNext() ? (Entry)a4.next() : null;
        Entry entry = a2 = a5.hasNext() ? (Entry)a5.next() : null;
        while (a6 != null && a2 != null) {
            if (a6.enum < a2.enum) {
                a6 = a4.hasNext() ? (Entry)a4.next() : null;
                continue;
            }
            if (a6.enum > a2.enum) {
                a2 = a5.hasNext() ? (Entry)a5.next() : null;
                continue;
            }
            double a7 = a6.false * a2.false;
            if (Double.compare(0.0, a7) != 0) {
                a3.add(new Entry(a6.enum, a7));
            }
            a6 = a4.hasNext() ? (Entry)a4.next() : null;
            a2 = a5.hasNext() ? (Entry)a5.next() : null;
        }
        return new SparseVector(this.enum, a3);
    }

    @Override
    public SparseVector ZERO() {
        return new SparseVector(this.enum);
    }

    private Vector break(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        DenseVector a4 = new DenseVector(a2);
        for (Entry a5 : a3.false) {
            a4.set(a5.enum, a5.false + a4.get(a5.enum));
        }
        return a4;
    }

    private SparseVector do(SparseVector a2, int a3) {
        Entry a4;
        SparseVector a5;
        MatrixPropertyUtils.throwIfNotEqualSize(a5, a2);
        LinkedList<Entry> a6 = new LinkedList<Entry>();
        java.util.Iterator a7 = a5.false.iterator();
        java.util.Iterator a8 = a2.false.iterator();
        Entry a9 = a7.hasNext() ? (Entry)a7.next() : null;
        Entry entry = a4 = a8.hasNext() ? (Entry)a8.next() : null;
        while (a9 != null || a4 != null) {
            if (a9 != null && (a4 == null || a9.enum < a4.enum)) {
                a6.add(new Entry(a9.enum, a9.false));
                a9 = a7.hasNext() ? (Entry)a7.next() : null;
                continue;
            }
            if (a4 != null && (a9 == null || a9.enum > a4.enum)) {
                a6.add(new Entry(a4.enum, (double)a3 * a4.false));
                a4 = a8.hasNext() ? (Entry)a8.next() : null;
                continue;
            }
            double a10 = a9.false + (double)a3 * a4.false;
            if (Double.compare(0.0, a10) != 0) {
                a6.add(new Entry(a9.enum, a10));
            }
            a9 = a7.hasNext() ? (Entry)a7.next() : null;
            a4 = a8.hasNext() ? (Entry)a8.next() : null;
        }
        return new SparseVector(a5.enum, a6);
    }

    @Override
    public SparseVector scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    static {
        Package.validate("BASIC");
    }

    private Vector do(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        Vector a4 = a2.opposite();
        for (Entry a5 : a3.false) {
            a4.set(a5.enum, a5.false + a4.get(a5.enum));
        }
        return a4;
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 59 * a2 + this.enum;
        a2 = 59 * a2 + (this.false != null ? this.false.hashCode() : 0);
        return a2;
    }

    @Override
    public SparseVector add(SparseVector that) {
        return this.do(that, 1);
    }

    @Override
    public SparseVector deepCopy() {
        return new SparseVector(this);
    }

    public SparseVector(int size) {
        this.enum = size;
        this.false = new LinkedList();
    }

    @Override
    public java.util.Iterator<Entry> iterator() {
        return new Iterator(this.false.listIterator());
    }

    @Override
    public double norm(double p) {
        if (p == Double.POSITIVE_INFINITY) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(this.toArray()));
        }
        if (p == Double.NEGATIVE_INFINITY) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(this.toArray()));
        }
        ArgumentAssertion.assertNotLessThan(p, 1.0, "p");
        double a2 = 0.0;
        for (Entry a3 : this.false) {
            a2 += Math.pow(a3.value(), p);
        }
        a2 = Math.pow(a2, 1.0 / p);
        return a2;
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this(size, SparseVector.do(size, indices, values));
    }

    @Override
    public Vector add(double c2) {
        double[] a2 = DoubleUtils.rep(c2, this.enum);
        for (Entry a3 : this.false) {
            int n = a3.enum - 1;
            a2[n] = a2[n] + a3.false;
        }
        return new DenseVector(a2);
    }

    @Override
    public Vector minus(Vector that) {
        if (that instanceof SparseVector) {
            return this.minus((SparseVector)that);
        }
        return this.do(that);
    }

    @Override
    public double norm() {
        return this.norm(2.0);
    }

    public SparseVector(Vector v) {
        this.enum = v.size();
        this.false = new LinkedList();
        for (int a2 = 1; a2 <= this.enum; ++a2) {
            double a3 = v.get(a2);
            if (a3 == 0.0) continue;
            Entry a4 = new Entry(a2, a3);
            this.false.add(a4);
        }
    }

    @Override
    public Vector minus(double c2) {
        return this.add(-c2);
    }

    @Override
    public double angle(Vector that) {
        double a2 = this.innerProduct(that);
        a2 /= this.norm();
        a2 /= that.norm();
        a2 = Math.acos(a2);
        return a2;
    }

    @Override
    public double get(int index) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, index);
        for (Entry a2 : this.false) {
            if (a2.enum == index) {
                return a2.false;
            }
            if (a2.enum <= index) continue;
            return 0.0;
        }
        return 0.0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Iterator
    implements java.util.Iterator<Entry> {
        private final ListIterator<Entry> enum;

        @Override
        public Entry next() {
            return this.enum.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove an element in a vector; set it to zero instead");
        }

        private Iterator(ListIterator<Entry> a2) {
            Iterator a3;
            a3.enum = a2;
        }

        @Override
        public boolean hasNext() {
            return this.enum.hasNext();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Entry {
        private double false;
        private int enum;

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry a2 = (Entry)obj;
            if (this.enum != a2.enum) {
                return false;
            }
            return Double.doubleToLongBits(this.false) == Double.doubleToLongBits(a2.false);
        }

        public Entry(int index, double value) {
            this.enum = index;
            this.false = value;
        }

        public int index() {
            return this.enum;
        }

        public double value() {
            return this.false;
        }

        public int hashCode() {
            int a2 = 3;
            a2 = 59 * a2 + this.enum;
            a2 = 59 * a2 + (int)(Double.doubleToLongBits(this.false) ^ Double.doubleToLongBits(this.false) >>> 32);
            return a2;
        }

        public String toString() {
            return String.format("[%d] %.4f", this.enum, this.false);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static enum Comparator implements java.util.Comparator<Entry>
        {
            INSTANCE;


            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1.enum < o2.enum) {
                    return -1;
                }
                if (o1.enum > o2.enum) {
                    return 1;
                }
                return 0;
            }

            private Comparator() {
                Comparator a2;
            }
        }
    }
}

