/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.PreconditionerFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.IterationMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.NullMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.tolerance.Tolerance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BiconjugateGradientSolver
implements IterativeLinearSystemSolver {
    private final int const;
    private final PreconditionerFactory case;
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int false;
    private final Tolerance enum;

    public BiconjugateGradientSolver(int maxIteration, Tolerance tolerance) {
        this(new PreconditionerFactory(){

            @Override
            public Preconditioner newInstance(Matrix A2) {
                return new IdentityPreconditioner();
            }
            {
                1 a2;
            }
        }, 50, maxIteration, tolerance);
    }

    public BiconjugateGradientSolver(PreconditionerFactory leftPreconditionerFactory, int residualRefreshRate, int maxIteration, Tolerance tolerance) {
        this.case = leftPreconditionerFactory;
        this.false = residualRefreshRate;
        this.const = maxIteration;
        this.enum = tolerance;
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        return new IterativeLinearSystemSolver.Solution(){
            private Vector this;
            private final Matrix int;
            private final Preconditioner true;
            private double do;
            private int long;
            private final Vector super;
            private Vector char;
            private Vector new;
            private final Matrix const;
            private Vector case;
            private boolean false;
            private Vector enum;
            {
                2 a2;
                a2.const = a2.problem.A();
                a2.super = a2.problem.b();
                a2.int = a2.const.t();
                a2.true = a2.BiconjugateGradientSolver.this.case.newInstance(a2.const);
                a2.do = 1.0;
                a2.long = 0;
            }

            public void setInitials(Vector ... initials) {
                this.this = initials[0];
                this.char = this.super.minus(this.const.multiply(this.this));
                this.new = this.char.deepCopy();
                this.case = this.this.ZERO();
                this.enum = this.this.ZERO();
                this.false = BiconjugateGradientSolver.this.enum.isResidualSmall(this.char.norm());
            }

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.this);
                Vector a2 = this.true.solve(this.char);
                Vector a3 = this.true.transposeSolve(this.new);
                double a4 = this.new.innerProduct(a2);
                if (Double.compare(a4, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<z, rTilde> = 0");
                }
                double a5 = a4 / this.do;
                this.case = a2.add(this.case.scaled(a5));
                this.enum = a3.add(this.enum.scaled(a5));
                Vector a6 = this.const.multiply(this.case);
                Vector a7 = this.int.multiply(this.enum);
                double a8 = a6.innerProduct(this.enum);
                if (Double.compare(a8, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<Ap, pTilde> = 0");
                }
                double a9 = a4 / a8;
                this.this = this.this.add(this.case.scaled(a9));
                if ((this.long + 1) % BiconjugateGradientSolver.this.false != 0) {
                    this.char = this.char.minus(a6.scaled(a9));
                    this.new = this.new.minus(a7.scaled(a9));
                } else {
                    this.char = this.super.minus(this.const.multiply(this.this));
                    this.new = this.super.minus(this.int.multiply(this.this));
                }
                this.do = a4;
                return monitor;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.long < BiconjugateGradientSolver.this.const && !this.false) {
                    this.step();
                    ++this.long;
                    this.false |= BiconjugateGradientSolver.this.enum.isResidualSmall(this.char.norm());
                }
                monitor.addIterate(this.this);
                if (!this.false) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, BiconjugateGradientSolver.this.const + " iterations exceeded");
                }
                return this.this;
            }
        };
    }
}

