/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary.SORSweep;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.IterationMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.monitor.NullMonitor;
import com.numericalmethod.suanshu.misc.algorithm.iterative.tolerance.Tolerance;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricSuccessiveOverrelaxationSolver
implements IterativeLinearSystemSolver {
    private final double case;
    private final Tolerance false;
    private final int enum;

    public SymmetricSuccessiveOverrelaxationSolver(double omega, int maxIteration, Tolerance tolerance) {
        this.case = omega;
        this.enum = maxIteration;
        this.false = tolerance;
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(problem.A()), "A must be a square matrix", new Object[0]);
        return new IterativeLinearSystemSolver.Solution(){
            int count;
            private Vector char;
            private final Matrix new;
            private boolean const;
            private final Vector case;
            private Vector false;
            private final SORSweep enum;

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.char);
                this.char = this.enum.forward(this.char);
                this.char = this.enum.backward(this.char);
                this.false = this.case.minus(this.new.multiply(this.char));
                return monitor;
            }
            {
                1 a2;
                a2.new = a2.problem.A();
                a2.case = a2.problem.b();
                a2.enum = new SORSweep(a2.new, a2.case, a2.SymmetricSuccessiveOverrelaxationSolver.this.case);
                a2.count = 0;
            }

            public void setInitials(Vector ... initials) {
                this.char = initials[0];
                this.false = this.case.minus(this.new.multiply(this.char));
                this.const = SymmetricSuccessiveOverrelaxationSolver.this.false.isResidualSmall(this.false.norm());
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.count < SymmetricSuccessiveOverrelaxationSolver.this.enum && !this.const) {
                    this.step();
                    ++this.count;
                    this.const |= SymmetricSuccessiveOverrelaxationSolver.this.false.isResidualSmall(this.false.norm());
                }
                monitor.addIterate(this.char);
                if (!this.const) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, SymmetricSuccessiveOverrelaxationSolver.this.enum + " exceeded");
                }
                return this.char;
            }
        };
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }
}

