/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixTable;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ElementaryOperation
implements MatrixTable {
    private final int case;
    private final int false;
    private final Vector[] enum;

    public ElementaryOperation swapRow(int i1, int i2) {
        Vector a2 = this.enum[i1 - 1];
        this.enum[i1 - 1] = this.enum[i2 - 1];
        this.enum[i2 - 1] = a2;
        return this;
    }

    public ElementaryOperation swapColumn(int j1, int j2) {
        for (Vector a2 : this.enum) {
            double a3 = a2.get(j1);
            a2.set(j1, a2.get(j2));
            a2.set(j2, a3);
        }
        return this;
    }

    public Matrix T() {
        return MatrixFactory.rbind(this.enum);
    }

    @Override
    public int nRows() {
        return this.case;
    }

    @Override
    public int nCols() {
        return this.false;
    }

    public String toString() {
        return this.T().toString();
    }

    public ElementaryOperation addRow(int i1, int i2, double c2) {
        Vector a2 = this.enum[i1 - 1];
        Vector a3 = this.enum[i2 - 1];
        for (int a4 = 1; a4 <= this.false; ++a4) {
            a2.set(a4, a2.get(a4) + c2 * a3.get(a4));
        }
        return this;
    }

    public ElementaryOperation scaleRow(int i, double c2) {
        Vector a2 = this.enum[i - 1];
        for (int a3 = 1; a3 <= this.false; ++a3) {
            a2.set(a3, c2 * a2.get(a3));
        }
        return this;
    }

    public ElementaryOperation(int nRows, int nCols) {
        this((Matrix)new DenseMatrix(nRows, nCols).ONE());
    }

    @Override
    @Deprecated
    public void set(int i, int j2, double value) throws MatrixAccessException {
        throw new UnsupportedOperationException("please use the elementary operations");
    }

    public ElementaryOperation(int dim) {
        this(dim, dim);
    }

    public ElementaryOperation scaleColumn(int j2, double c2) {
        for (Vector a2 : this.enum) {
            a2.set(j2, c2 * a2.get(j2));
        }
        return this;
    }

    @Override
    public double get(int i, int j2) {
        return this.enum[i - 1].get(j2);
    }

    public ElementaryOperation addColumn(int j1, int j2, double c2) {
        for (Vector a2 : this.enum) {
            a2.set(j1, a2.get(j1) + c2 * a2.get(j2));
        }
        return this;
    }

    public ElementaryOperation(Matrix A2) {
        this.case = A2.nRows();
        this.false = A2.nCols();
        this.enum = new Vector[this.case];
        for (int a2 = 1; a2 <= this.case; ++a2) {
            this.enum[a2 - 1] = A2.getRow(a2);
        }
    }
}

