/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixSingularityException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.LU;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractBivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.BivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MatrixMeasure {
    private static double[] do(final Matrix a2, final BivariateRealFunction a3) throws MultipleExecutionException {
        int a4;
        int a5 = a2.nRows();
        int a6 = a2.nCols();
        int a7 = a5;
        final int a8 = a4 = a6;
        final double[] a9 = new double[a7];
        Inner.enum.forLoop(0, a7, new LoopBody(){

            @Override
            public void run(int i) throws Exception {
                a9[i] = 0.0;
                for (int a22 = 1; a22 <= a8; ++a22) {
                    double a32;
                    double a4 = a2.get(i + 1, a22);
                    a9[i] = a32 = a3.evaluate(a9[i], a4);
                }
            }
            {
                1 a22;
            }
        });
        return a9;
    }

    public static int rank(Matrix A2, double epsilon) {
        SVD a2 = new SVD(A2, false, epsilon);
        double[] a3 = a2.getSingularValues();
        int a4 = 0;
        for (int a5 = 0; a5 < Math.min(A2.nRows(), A2.nCols()); ++a5) {
            if (!(a3[a5] > epsilon)) continue;
            ++a4;
        }
        return a4;
    }

    @Deprecated
    public static int nullity(Matrix A2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static double max(Matrix A2) {
        double a2 = Double.NEGATIVE_INFINITY;
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (int a4 = 1; a4 <= A2.nCols(); ++a4) {
                if (!(A2.get(a3, a4) > a2)) continue;
                a2 = A2.get(a3, a4);
            }
        }
        return a2;
    }

    public static double Frobenius(Matrix A2) {
        double a2 = 0.0;
        try {
            if (A2.nRows() < 3000) {
                throw new RuntimeException();
            }
            double[] a3 = MatrixMeasure.do(A2, new AbstractBivariateRealFunction(){
                {
                    2 a2;
                }

                @Override
                public double evaluate(double f0, double x) {
                    double a2 = f0 + x * x;
                    return a2;
                }
            });
            for (int a4 = 0; a4 < a3.length; ++a4) {
                a2 += a3[a4];
            }
        }
        catch (Exception a5) {
            for (int a6 = 1; a6 <= A2.nRows(); ++a6) {
                for (int a7 = 1; a7 <= A2.nCols(); ++a7) {
                    double a8 = A2.get(a6, a7);
                    a2 += a8 * a8;
                }
            }
        }
        return Math.sqrt(a2);
    }

    public static double tr(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "trace applies only to square matrix", new Object[0]);
        double a2 = 0.0;
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            a2 += A2.get(a3, a3);
        }
        return a2;
    }

    public static double min(Matrix A2) {
        double a2 = Double.POSITIVE_INFINITY;
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (int a4 = 1; a4 <= A2.nCols(); ++a4) {
                if (!(A2.get(a3, a4) < a2)) continue;
                a2 = A2.get(a3, a4);
            }
        }
        return a2;
    }

    public static double det(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "only a square matrix has determinant", new Object[0]);
        int a2 = A2.nRows();
        double a3 = 0.0;
        switch (a2) {
            case 1: {
                a3 = A2.get(1, 1);
                break;
            }
            case 2: {
                a3 = A2.get(1, 1) * A2.get(2, 2) - A2.get(2, 1) * A2.get(1, 2);
                break;
            }
            case 3: {
                a3 = A2.get(1, 1) * A2.get(2, 2) * A2.get(3, 3) - A2.get(1, 1) * A2.get(2, 3) * A2.get(3, 2) - A2.get(1, 2) * A2.get(2, 1) * A2.get(3, 3) + A2.get(1, 2) * A2.get(2, 3) * A2.get(3, 1) + A2.get(1, 3) * A2.get(2, 1) * A2.get(3, 2) - A2.get(1, 3) * A2.get(2, 2) * A2.get(3, 1);
                break;
            }
            default: {
                try {
                    LU a4 = new LU(A2);
                    a3 = a4.P().sign();
                    UpperTriangularMatrix a5 = a4.U();
                    for (int a6 = 1; a6 <= a2; ++a6) {
                        a3 *= a5.get(a6, a6);
                    }
                    break;
                }
                catch (MatrixSingularityException a7) {
                    a3 = 0.0;
                }
            }
        }
        return a3;
    }

    public static int rank(Matrix A2) {
        return MatrixMeasure.rank(A2, PrecisionUtils.autoEpsilon(A2));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Inner {
        private static final ParallelExecutor enum = new ParallelExecutor(MatrixMeasure.class.getSimpleName());

        private Inner() {
            Inner a2;
        }
    }
}

