/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixAccess;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SubMatrixRef
implements Matrix {
    private final int[] const;
    private final Matrix case;
    private final int[] false;
    private static final MatrixMathOperation enum = new AutoParallelMatrixMathOperation();

    @Override
    public int nCols() {
        return this.false.length;
    }

    public SubMatrixRef(Matrix A2, int rowFrom, int rowTo, int colFrom, int colTo) {
        this(A2, DoubleUtils.seq(rowFrom, rowTo, 1), DoubleUtils.seq(colFrom, colTo, 1));
    }

    @Override
    public Matrix add(Matrix that) {
        return enum.add(this, that);
    }

    @Override
    public Matrix t() {
        return new DenseMatrix(this).t();
    }

    @Override
    public Matrix minus(Matrix that) {
        return enum.minus(this, that);
    }

    public SubMatrixRef(Matrix A2) {
        this(A2, 1, A2.nRows(), 1, A2.nCols());
    }

    public String toString() {
        return new DenseMatrix(this).toString();
    }

    @Override
    public Vector multiply(Vector v) {
        return enum.multiply((MatrixAccess)this, v);
    }

    @Override
    public Vector getColumn(int j2) {
        Vector a2 = this.case.getColumn(this.false[j2 - 1]);
        Vector a3 = VectorFactory.subVector(a2, this.const);
        return a3;
    }

    public SubMatrixRef(Matrix A2, int[] rows, int[] cols) {
        this.case = A2;
        this.const = Arrays.copyOf(rows, rows.length);
        this.false = Arrays.copyOf(cols, cols.length);
    }

    @Override
    public int nRows() {
        return this.const.length;
    }

    @Override
    @Deprecated
    public void set(int i, int j2, double value) throws MatrixAccessException {
        throw new MatrixAccessException("SubMatrixRef is immutable.");
    }

    @Override
    public Matrix multiply(Matrix that) {
        return enum.multiply((MatrixAccess)this, that);
    }

    @Override
    public Matrix scaled(double scalar) {
        return new DenseMatrix(this).scaled(scalar);
    }

    @Override
    public Vector getRow(int i) {
        Vector a2 = this.case.getRow(this.const[i - 1]);
        Vector a3 = VectorFactory.subVector(a2, this.false);
        return a3;
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public SubMatrixRef deepCopy() {
        return this;
    }

    @Override
    public double get(int i, int j2) {
        return this.case.get(this.const[i - 1], this.false[j2 - 1]);
    }

    @Override
    public Matrix ONE() {
        return new DenseMatrix(this.nRows(), this.nCols()).ONE();
    }

    @Override
    public Matrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols()).ZERO();
    }
}

