/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.Basis;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class HouseholderContext {
    public final Vector v;
    public final Vector generator;
    public final double beta;
    public final double lambda;

    public String toString() {
        return String.format("[%s]; beta=%f; generator=%s; lambda=%f", this.v, this.beta, this.generator, this.lambda);
    }

    public HouseholderContext(Vector v, double beta, Vector generator, double lambda) {
        this.v = v;
        this.beta = beta;
        this.generator = generator;
        this.lambda = lambda;
    }

    public static HouseholderContext getContext(Vector x) {
        double a2;
        Vector a3;
        double a4;
        double a5 = x.innerProduct(x);
        double a6 = Math.sqrt(a5);
        double a7 = x.get(1);
        double d = a4 = a7 > 0.0 ? -a6 : a6;
        if (!DoubleUtils.isZero(a4, 0.0)) {
            Basis a8 = new Basis(x.size(), 1);
            a3 = a8.scaled(-a4).add(x);
            double a9 = a3.get(1);
            double a10 = a5 - a7 * a7 + a9 * a9;
            a2 = 2.0 / a10;
        } else {
            a3 = new SparseVector(x.size());
            a2 = 0.0;
        }
        return new HouseholderContext(a3, a2, x, a4);
    }
}

