/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.generic.matrixtype;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.algebra.linear.matrix.generic.GenericMatrix;
import com.numericalmethod.suanshu.algebra.structure.Field;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.datastructure.Table;
import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GenericFieldMatrix<F extends Field<F>>
implements GenericMatrix<GenericFieldMatrix<F>, F> {
    private final int const;
    private final int case;
    private final F false;
    private F[][] enum;

    private boolean do(F[][] a2) {
        GenericFieldMatrix a3;
        for (int a4 = 0; a4 < a3.case; ++a4) {
            for (int a5 = 0; a5 < a3.const; ++a5) {
                if (a3.enum[a4][a5].equals(a2[a4][a5])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int nRows() {
        return this.case;
    }

    public GenericFieldMatrix(int nRows, int nCols, F init) {
        this.case = nRows;
        this.const = nCols;
        this.false = init;
        this.enum = (Field[][])Array.newInstance(init.getClass(), nRows, nCols);
        for (int a2 = 0; a2 < nRows; ++a2) {
            for (int a3 = 0; a3 < nCols; ++a3) {
                this.enum[a2][a3] = init;
            }
        }
    }

    @Override
    public GenericFieldMatrix<F> opposite() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.case, this.const, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.case; ++a3) {
            for (int a4 = 0; a4 < this.const; ++a4) {
                a2.enum[a3][a4] = (Field)this.enum[a3][a4].opposite();
            }
        }
        return a2;
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 61 * a2 + this.case;
        a2 = 61 * a2 + this.const;
        a2 = 61 * a2 + Arrays.deepHashCode(this.enum);
        a2 = 61 * a2 + (this.false != null ? this.false.hashCode() : 0);
        return a2;
    }

    @Override
    public void set(int row, int col, F value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.enum[row - 1][col - 1] = value;
    }

    @Override
    public GenericFieldMatrix<F> ZERO() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.case, this.const, (Field)this.false.ZERO());
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> minus(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.case, this.const, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.case; ++a3) {
            for (int a4 = 0; a4 < this.const; ++a4) {
                a2.enum[a3][a4] = (Field)this.enum[a3][a4].minus(that.enum[a3][a4]);
            }
        }
        return a2;
    }

    public GenericFieldMatrix(F[][] data) {
        this.case = data.length;
        this.const = data[0].length;
        this.false = (Field)data[0][0].ZERO();
        this.enum = (Field[][])Array.newInstance(this.false.getClass(), this.case, this.const);
        for (int a2 = 0; a2 < this.case; ++a2) {
            if (data[a2].length != this.const) {
                this.enum = null;
                throw new IllegalArgumentException("data is a jagged array");
            }
            for (int a3 = 0; a3 < this.const; ++a3) {
                this.enum[a2][a3] = data[a2][a3];
            }
        }
    }

    @Override
    public GenericFieldMatrix<F> add(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.case, this.const, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.case; ++a3) {
            for (int a4 = 0; a4 < this.const; ++a4) {
                a2.enum[a3][a4] = (Field)this.enum[a3][a4].add(that.enum[a3][a4]);
            }
        }
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> scaled(F scalar) {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.case, this.const, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.case; ++a3) {
            for (int a4 = 0; a4 < this.const; ++a4) {
                a2.enum[a3][a4] = (Field)this.enum[a3][a4].multiply(scalar);
            }
        }
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> multiply(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.case, that.const, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.case; ++a3) {
            for (int a4 = 0; a4 < that.const; ++a4) {
                Field a5 = (Field)this.false.ZERO();
                for (int a6 = 0; a6 < this.const; ++a6) {
                    Field a7 = (Field)this.enum[a3][a6].multiply(that.enum[a6][a4]);
                    a5 = a5.add(a7);
                }
                a2.enum[a3][a4] = a5;
            }
        }
        return a2;
    }

    @Override
    public int nCols() {
        return this.const;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericFieldMatrix a2 = (GenericFieldMatrix)obj;
        if (!DimensionCheck.isSameDimension(this, a2)) {
            return false;
        }
        return this.enum == a2.enum || this.enum != null && a2.enum != null && this.do((Field[][])a2.enum);
    }

    @Override
    public F get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.enum[row - 1][col - 1];
    }

    @Override
    public GenericFieldMatrix<F> ONE() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.case, this.const, (Field)this.false.ZERO());
        for (int a3 = 0; a3 < this.case; ++a3) {
            a2.enum[a3][a3] = (Field)this.false.ONE();
        }
        return a2;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append(String.format("%dx%d\n", this.case, this.const));
        a3.append("\t");
        for (a2 = 1; a2 <= this.const; ++a2) {
            a3.append(String.format("[,%d] ", a2));
        }
        a3.append("\n");
        for (a2 = 1; a2 <= this.case; ++a2) {
            a3.append(String.format("[%d,] ", a2));
            for (int a4 = 1; a4 <= this.const; ++a4) {
                a3.append(String.format("%s, ", this.get(a2, a4).toString()));
            }
            a3.append("\n");
        }
        return a3.toString();
    }
}

