/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.generic.matrixtype;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.generic.GenericMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.generic.matrixtype.GenericFieldMatrix;
import com.numericalmethod.suanshu.algebra.structure.Field;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.Real;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RealMatrix
implements GenericMatrix<RealMatrix, Real> {
    private final GenericFieldMatrix<Real> enum;

    public RealMatrix(int nRows, int nCols) {
        this(new GenericFieldMatrix<Real>(nRows, nCols, Real.ZERO));
    }

    @Override
    public void set(int row, int col, Real value) {
        this.enum.set(row, col, value);
    }

    @Override
    public RealMatrix opposite() {
        return new RealMatrix((GenericFieldMatrix<Real>)this.enum.opposite());
    }

    public DenseMatrix doubleValue() {
        DenseMatrix a2 = new DenseMatrix(this.nRows(), this.nCols());
        for (int a3 = 1; a3 <= this.nRows(); ++a3) {
            for (int a4 = 1; a4 <= this.nCols(); ++a4) {
                a2.set(a3, a4, this.enum.get(a3, a4).doubleValue());
            }
        }
        return a2;
    }

    @Override
    public Real get(int row, int col) {
        return this.enum.get(row, col);
    }

    private static Real[][] do(double[][] a2) {
        int a3 = a2.length;
        int a4 = a2[0].length;
        Real[][] a5 = new Real[a3][a4];
        for (int a6 = 0; a6 < a3; ++a6) {
            if (a2[a6].length != a4) {
                throw new IllegalArgumentException("data is a jagged array");
            }
            for (int a7 = 0; a7 < a4; ++a7) {
                a5[a6][a7] = new Real(a2[a6][a7]);
            }
        }
        return a5;
    }

    @Override
    public int nCols() {
        return this.enum.nCols();
    }

    @Override
    public RealMatrix minus(RealMatrix that) {
        return new RealMatrix(this.enum.minus(that.enum));
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 37 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        return a2;
    }

    static {
        Package.validate("BASIC");
    }

    private RealMatrix(GenericFieldMatrix<Real> a2) {
        RealMatrix a3;
        a3.enum = a2;
    }

    @Override
    public int nRows() {
        return this.enum.nRows();
    }

    public RealMatrix(double[][] data) {
        this(RealMatrix.do(data));
    }

    public String toString() {
        return this.enum.toString();
    }

    @Override
    public RealMatrix ZERO() {
        return new RealMatrix(new GenericFieldMatrix<Real>(this.nRows(), this.nCols(), Real.ZERO));
    }

    public RealMatrix(Real[][] data) {
        this(new GenericFieldMatrix((Field[][])data));
    }

    @Override
    public RealMatrix add(RealMatrix that) {
        return new RealMatrix(this.enum.add(that.enum));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealMatrix a2 = (RealMatrix)obj;
        return this.enum == a2.enum || this.enum != null && this.enum.equals(a2.enum);
    }

    @Override
    public RealMatrix multiply(RealMatrix that) {
        return new RealMatrix(this.enum.multiply(that.enum));
    }

    @Override
    public RealMatrix ONE() {
        return new RealMatrix((GenericFieldMatrix<Real>)new GenericFieldMatrix<Real>(this.nRows(), this.nCols(), Real.ZERO).ONE());
    }

    @Override
    public RealMatrix scaled(Real scalar) {
        return new RealMatrix((GenericFieldMatrix<Real>)this.enum.scaled((Field)scalar));
    }
}

