/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.qr.HouseholderQR;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.OLSSolver;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RealVectorSpace {
    private List<Vector> const;
    private int case;
    private List<Vector> false = new ArrayList<Vector>();
    private final double enum;

    public int rank() {
        return this.case;
    }

    public List<Vector> getComplement() {
        return Collections.unmodifiableList(this.const);
    }

    public RealVectorSpace(Vector ... elements) {
        this(Arrays.asList(elements));
    }

    private void do(Matrix a2) {
        Vector a3;
        int a4;
        RealVectorSpace a5;
        HouseholderQR a6 = new HouseholderQR(a2, a5.enum);
        Matrix a7 = a6.squareQ();
        a5.case = a6.rank();
        for (a4 = 1; a4 <= a5.case; ++a4) {
            a3 = a7.getColumn(a4);
            a3 = a3.scaled(1.0 / a3.norm());
            a5.false.add(a3);
        }
        for (a4 = a5.case + 1; a4 <= a7.nCols(); ++a4) {
            a3 = a7.getColumn(a4);
            a3 = a3.scaled(1.0 / a3.norm());
            a5.const.add(a3);
        }
    }

    public RealVectorSpace(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(A2)));
    }

    public RealVectorSpace(List<Vector> elements) {
        this(MatrixFactory.cbind(elements));
    }

    public RealVectorSpace(Matrix A2, double epsilon) {
        this.const = new ArrayList<Vector>();
        this.enum = epsilon;
        this.do(A2);
    }

    @Deprecated
    public boolean isInKernel(Vector b2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Vector getSpanningCoefficients(Vector b2) {
        Vector a2 = null;
        try {
            Matrix a3 = MatrixFactory.cbind(this.false);
            OLSSolver a4 = new OLSSolver(this.enum);
            a2 = a4.solve(new LSProblem(a3, b2));
            Vector a5 = a3.multiply(a2);
            if (!MatrixPropertyUtils.areEqual(a5, b2, this.enum)) {
                a2 = null;
            }
        }
        catch (Exception a6) {
            a2 = null;
        }
        return a2;
    }

    public RealVectorSpace(double epsilon, Vector ... elements) {
        this(Arrays.asList(elements), epsilon);
    }

    @Deprecated
    public Vector getLinearSpan(double ... d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Vector> getBasis() {
        return Collections.unmodifiableList(this.false);
    }

    public RealVectorSpace(List<Vector> elements, double epsilon) {
        this(MatrixFactory.cbind(elements), epsilon);
    }

    public boolean isSpanned(Vector b2) {
        Vector a2 = this.getSpanningCoefficients(b2);
        return a2 != null;
    }
}

