/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate.BivariateGrid;
import com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate.BivariateGridInterpolation;
import com.numericalmethod.suanshu.analysis.curvefit.interpolation.bivariate.BivariateInterpolationUtils;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractRealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.tuple.Triple;

public class BilinearInterpolation
implements BivariateGridInterpolation {
    @Override
    public RealScalarFunction interpolate(final BivariateGrid grid) {
        return new AbstractRealScalarFunction(2){
            {
                1 a3;
                super(a2);
            }

            @Override
            public Double evaluate(Vector coordinates) {
                double a2 = coordinates.get(1);
                double a3 = coordinates.get(2);
                Triple[][] a4 = BivariateInterpolationUtils.getSurroundingPoints(grid, a2, a3);
                double a5 = (a2 - a4[0][0].x()) / (a4[1][1].x() - a4[0][0].x());
                double a6 = (a3 - a4[0][0].y()) / (a4[1][1].y() - a4[0][0].y());
                return (1.0 - a5) * (1.0 - a6) * a4[0][0].z() + (1.0 - a5) * a6 * a4[0][1].z() + a5 * (1.0 - a6) * a4[1][0].z() + a5 * a6 * a4[1][1].z();
            }
        };
    }
}

