/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.curvefit.interpolation.univariate;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LUSolver;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.curvefit.interpolation.univariate.Interpolation;
import com.numericalmethod.suanshu.analysis.curvefit.interpolation.univariate.PairLookup;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.tuple.OrderedPairs;
import com.numericalmethod.suanshu.analysis.function.tuple.SortedOrderedPairs;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.SimpleDoubleArrayOperation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CubicSpline
implements Interpolation {
    private double[] do(double[] a2, double[] a3) {
        CubicSpline a4;
        DenseVector a5 = new DenseVector(a2);
        DenseVector a6 = new DenseVector(a3);
        Matrix a7 = a4.do(a5);
        Vector a8 = a4.break(a6);
        Vector a9 = new LUSolver().solve(new LSProblem(a7, a8));
        return a9.toArray();
    }

    private Vector break(Vector a2) {
        DenseVector a3 = new DenseVector(a2.size() + 1);
        for (int a4 = 2; a4 <= a2.size(); ++a4) {
            a3.set(a4, 6.0 * (a2.get(a4) - a2.get(a4 - 1)));
        }
        return a3;
    }

    @Override
    public UnivariateRealFunction fit(OrderedPairs pairs) {
        final SortedOrderedPairs a2 = new SortedOrderedPairs(pairs);
        int a3 = pairs.size();
        double[] a4 = a2.x();
        double[] a5 = a2.y();
        final double[] a6 = DoubleUtils.diff(a4);
        double[] a7 = new SimpleDoubleArrayOperation().divide(DoubleUtils.diff(a5), a6);
        final double[] a8 = this.do(a6, a7);
        final double[] a9 = new double[a3 - 1];
        final double[] a10 = new double[a3 - 1];
        for (int a11 = 0; a11 < a9.length; ++a11) {
            double a12 = 6.0 * a6[a11];
            double a13 = a6[a11] * a6[a11];
            a9[a11] = (6.0 * a5[a11 + 1] - a13 * a8[a11 + 1]) / a12;
            a10[a11] = (6.0 * a5[a11] - a13 * a8[a11]) / a12;
        }
        return new AbstractUnivariateRealFunction(){
            private final PairLookup enum;

            @Override
            public double evaluate(double x) {
                ArgumentAssertion.assertRange(x, this.enum.first().x(), this.enum.last().x(), "x");
                int a22 = this.enum.getFloorIndex(x);
                if (a22 == this.enum.size() - 1) {
                    return this.enum.last().y();
                }
                double a3 = this.enum.get(a22).x();
                double a4 = this.enum.get(a22 + 1).x();
                double a5 = a9[a22] * (x - a3);
                double a62 = a10[a22] * (a4 - x);
                double a7 = (x - a3) * (x - a3) * (x - a3) * a8[a22 + 1];
                double a82 = (a4 - x) * (a4 - x) * (a4 - x) * a8[a22];
                double a92 = 6.0 * a6[a22];
                double a102 = a5 + a62 + (a7 + a82) / a92;
                return a102;
            }
            {
                1 a22;
                a22.enum = new PairLookup(a22.a2);
            }
        };
    }

    static {
        Package.validate("BASIC");
    }

    private Matrix do(Vector a2) {
        double[] a3 = a2.toArray();
        a3[0] = 0.0;
        double[] a4 = new double[a2.size() + 1];
        a4[0] = 1.0;
        for (int a5 = 1; a5 < a4.length - 1; ++a5) {
            a4[a5] = 2.0 * (a2.get(a5) + a2.get(a5 + 1));
        }
        a4[a4.length - 1] = 1.0;
        double[] a6 = a2.toArray();
        a6[a6.length - 1] = 0.0;
        return new TridiagonalMatrix(new double[][]{a3, a4, a6});
    }
}

