/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.curvefit.interpolation.univariate;

import com.numericalmethod.suanshu.analysis.curvefit.interpolation.univariate.Interpolation;
import com.numericalmethod.suanshu.analysis.curvefit.interpolation.univariate.PairLookup;
import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.tuple.OrderedPairs;
import com.numericalmethod.suanshu.analysis.function.tuple.Pair;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;

public class LinearInterpolation
implements Interpolation {
    @Override
    public UnivariateRealFunction fit(OrderedPairs f) {
        ArgumentAssertion.assertGreaterThan(f.size(), 1, "the number of points");
        final PairLookup a2 = new PairLookup(f);
        return new AbstractUnivariateRealFunction(){
            {
                1 a22;
            }

            @Override
            public double evaluate(double x) {
                int a22;
                Pair a3;
                Pair a4;
                if (x < a2.first().x()) {
                    a4 = a2.get(0);
                    a3 = a2.get(1);
                } else if (x >= a2.last().x()) {
                    a22 = a2.size();
                    a4 = a2.get(a22 - 2);
                    a3 = a2.get(a22 - 1);
                } else {
                    a22 = a2.getFloorIndex(x);
                    a4 = a2.get(a22);
                    a3 = a2.get(a22 + 1);
                }
                double a5 = FunctionOps.linearInterpolate(x, a4.x(), a4.y(), a3.x(), a3.y());
                return a5;
            }
        };
    }
}

