/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.rungekutta;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.problem.DerivativeFunction;
import com.numericalmethod.suanshu.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaStepper;

public class RungeKutta5
implements RungeKuttaStepper {
    @Override
    public Vector step(DerivativeFunction dy, Vector y0, double x0, double x1, double h) {
        Vector a2 = dy.evaluate(x0, y0);
        Vector a3 = dy.evaluate(x0 + h / 4.0, y0.add(a2.scaled(h / 4.0)));
        Vector a4 = dy.evaluate(x0 + h / 4.0, y0.add(a2.scaled(h / 8.0)).add(a3.scaled(h / 8.0)));
        Vector a5 = dy.evaluate(x0 + h / 2.0, y0.add(a3.scaled(-h / 2.0)).add(a4.scaled(h)));
        Vector a6 = dy.evaluate(x0 + 3.0 * h / 4.0, y0.add(a2.scaled(h * 3.0 / 16.0).add(a5.scaled(h * 9.0 / 16.0))));
        Vector a7 = dy.evaluate(x1, y0.add(a2.scaled(h * -3.0 / 7.0)).add(a3.scaled(h * 2.0 / 7.0)).add(a4.scaled(h * 12.0 / 7.0)).add(a5.scaled(h * -12.0 / 7.0)).add(a6.scaled(h * 8.0 / 7.0)));
        Vector a8 = y0.add(a2.scaled(h * 7.0 / 90.0)).add(a4.scaled(h * 32.0 / 90.0)).add(a5.scaled(h * 12.0 / 90.0)).add(a6.scaled(h * 32.0 / 90.0)).add(a7.scaled(h * 7.0 / 90.0));
        return a8;
    }
}

