/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.hyperbolic.dim2;

import com.numericalmethod.suanshu.analysis.differentialequation.pde.PDESolver;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.PDESolutionTimeSpaceGrid2D;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.hyperbolic.dim2.WaveEquation2D;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class ExplicitCentralDifference2D
implements PDESolver {
    public PDESolutionTimeSpaceGrid2D solve(WaveEquation2D pde, final int m2, final int n, final int p) {
        int a2;
        int a3;
        ArgumentAssertion.assertGreaterThan(m2, 1, "the number of time-axis grid points");
        ArgumentAssertion.assertGreaterThan(n, 1, "the number of x-axis grid points");
        ArgumentAssertion.assertGreaterThan(p, 1, "the number of y-axis grid points");
        final double[] a4 = DoubleUtils.seq(0.0, pde.T(), m2 + 1);
        final double[] a5 = DoubleUtils.seq(0.0, pde.a(), n + 2);
        final double[] a6 = DoubleUtils.seq(0.0, pde.b(), p + 2);
        final double[][][] a7 = new double[m2 + 1][n + 2][p + 2];
        double a8 = a4[1];
        double a9 = a5[1];
        double a10 = a6[1];
        double a11 = pde.beta() * a8 * a8 / (a9 * a9);
        double a12 = pde.beta() * a8 * a8 / (a10 * a10);
        for (a3 = 1; a3 <= n; ++a3) {
            for (a2 = 1; a2 <= p; ++a2) {
                a7[0][a3][a2] = pde.f(a5[a3], a6[a2]);
            }
        }
        for (a3 = 1; a3 <= n; ++a3) {
            for (a2 = 1; a2 <= p; ++a2) {
                double a13 = a11 * (a7[0][a3 - 1][a2] + a7[0][a3 + 1][a2]);
                double a14 = 2.0 * (1.0 - a11 - a12) * a7[0][a3][a2];
                double a15 = a12 * (a7[0][a3][a2 - 1] + a7[0][a3][a2 + 1]);
                double a16 = a8 * pde.g(a5[a3], a6[a2]);
                a7[1][a3][a2] = 0.5 * (a13 + a14 + a15) + a16;
            }
        }
        a3 = 1;
        while (a3 + 1 <= m2) {
            for (a2 = 1; a2 <= n; ++a2) {
                for (int a17 = 1; a17 <= p; ++a17) {
                    double a18 = a11 * (a7[a3][a2 - 1][a17] + a7[a3][a2 + 1][a17]);
                    double a19 = 2.0 * (1.0 - a11 - a12) * a7[a3][a2][a17];
                    double a20 = a12 * (a7[a3][a2][a17 - 1] + a7[a3][a2][a17 + 1]);
                    double a21 = a7[a3 - 1][a2][a17];
                    a7[a3 + 1][a2][a17] = a18 + a19 + a20 - a21;
                }
            }
            ++a3;
        }
        return new PDESolutionTimeSpaceGrid2D(){

            @Override
            public int p() {
                return p;
            }

            @Override
            public int m() {
                return m2;
            }

            @Override
            public double y(int j2) {
                ArgumentAssertion.assertRange(j2, 0, p + 1, "j");
                return a6[j2];
            }

            @Override
            public double t(int k2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                return a4[k2];
            }

            @Override
            public double x(int i) {
                ArgumentAssertion.assertRange(i, 0, n + 1, "i");
                return a5[i];
            }

            @Override
            public int n() {
                return n;
            }

            @Override
            public double u(int k2, int i, int j2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                ArgumentAssertion.assertRange(i, 0, n + 1, "i");
                ArgumentAssertion.assertRange(j2, 0, p + 1, "j");
                return a7[k2][i][j2];
            }
            {
                1 a2;
            }
        };
    }

    static {
        Package.validate("OPDE");
    }
}

