/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.PDESolver;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.PDESolutionTimeSpaceGrid1D;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.ConvectionDiffusionEquation1D;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.PropagationByThomas;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.PropagationOverTime;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CrankNicolsonConvectionDiffusionEquation1D
implements PDESolver {
    private final PropagationOverTime enum;

    public PDESolutionTimeSpaceGrid1D solve(ConvectionDiffusionEquation1D pde, final int m2, final int n) {
        ArgumentAssertion.assertGreaterThan(m2, 0, "the number of time-axis grid points");
        ArgumentAssertion.assertGreaterThan(n, 0, "the number of space-axis grid points");
        final double[] a2 = DoubleUtils.seq(0.0, pde.T(), m2 + 1);
        final double[] a3 = DoubleUtils.seq(0.0, pde.a(), n + 2);
        this.enum.initialize(pde, m2, n);
        final Vector[] a4 = this.enum.u(a2, a3);
        return new PDESolutionTimeSpaceGrid1D(){
            {
                1 a22;
            }

            @Override
            public double t(int k2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                return a2[k2];
            }

            @Override
            public double u(int k2, int j2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                if (j2 == 0 || j2 == n + 1) {
                    throw new UnsupportedOperationException("boundary values are not available");
                }
                return a4[k2].get(j2);
            }

            @Override
            public double x(int j2) {
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                return a3[j2];
            }

            @Override
            public int m() {
                return m2;
            }

            @Override
            public int n() {
                return n;
            }
        };
    }

    public CrankNicolsonConvectionDiffusionEquation1D() {
        this(new PropagationByThomas());
    }

    public CrankNicolsonConvectionDiffusionEquation1D(PropagationOverTime propagation) {
        this.enum = propagation;
    }
}

