/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.ConvectionDiffusionEquation1D;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.DoubleUtils;

public abstract class PropagationOverTime {
    int m;
    double[] x;
    ConvectionDiffusionEquation1D pde;
    double dx;
    double lambda;
    int n;
    double dt;

    abstract Vector[] u(double[] var1, double[] var2);

    TridiagonalMatrix getLHS(double a2) {
        PropagationOverTime a3;
        double a4 = a2 + 0.5 * a3.dt;
        double[] a5 = new double[a3.n - 1];
        double[] a6 = new double[a3.n];
        double[] a7 = new double[a3.n - 1];
        double a8 = a3.pde.c1();
        double a9 = a3.pde.c2();
        double a10 = a8 + (1.0 - a8) * a3.dx;
        double a11 = a9 + (1.0 - a9) * a3.dx;
        double a12 = a3.pde.sigma(a4, a3.x[1]);
        double a13 = a3.pde.mu(a4, a3.x[1]);
        a6[0] = 1.0 + 2.0 * a3.lambda * a12 - a3.lambda * a8 / a10 * (a12 + a3.dx / 2.0 * a13);
        a7[0] = a3.lambda * (-a12 + a3.dx / 2.0 * a13);
        for (int a14 = 1; a14 < a3.n - 1; ++a14) {
            double a15 = a3.pde.sigma(a4, a3.x[a14 + 1]);
            double a16 = a3.pde.mu(a4, a3.x[a14 + 1]);
            a5[a14 - 1] = a3.lambda * (-a15 - a3.dx / 2.0 * a16);
            a6[a14] = 1.0 + 2.0 * a3.lambda * a15;
            a7[a14] = a3.lambda * (-a15 + a3.dx / 2.0 * a16);
        }
        double a17 = a3.pde.sigma(a4, a3.x[a3.n]);
        double a18 = a3.pde.mu(a4, a3.x[a3.n]);
        a6[a3.n - 1] = 1.0 + 2.0 * a3.lambda * a17 - a3.lambda * a9 / a11 * (a17 - a3.dx / 2.0 * a18);
        a5[a3.n - 2] = a3.lambda * (-a17 - a3.dx / 2.0 * a18);
        return new TridiagonalMatrix(new double[][]{a7, a6, a5});
    }

    Vector getRHS(Vector a2, double a3) {
        PropagationOverTime a4;
        double a5 = a3 + 0.5 * a4.dt;
        double a6 = a3 + a4.dt;
        DenseVector a7 = new DenseVector(a4.n);
        double a8 = a4.pde.c1();
        double a9 = a4.pde.c2();
        double a10 = a8 + (1.0 - a8) * a4.dx;
        double a11 = a9 + (1.0 - a9) * a4.dx;
        double a12 = a4.pde.sigma(a5, a4.x[1]);
        double a13 = a4.pde.mu(a5, a4.x[1]);
        double a14 = a2.get(2) * a4.lambda * (a12 - a4.dx / 2.0 * a13) + a2.get(1) * (1.0 - 2.0 * a4.lambda * a12 + a4.lambda * a8 / a10 * (a12 + a4.dx / 2.0 * a13)) + a4.lambda * (a4.pde.g1(a3) + a4.pde.g1(a6)) * a4.dx / a10 * (a12 + a4.dx / 2.0 * a13) + a4.pde.R(a5, a4.x[1]) * a4.dt;
        a7.set(1, a14);
        for (int a15 = 2; a15 < a4.n; ++a15) {
            double a16 = a4.pde.sigma(a5, a4.x[a15]);
            double a17 = a4.pde.mu(a5, a4.x[a15]);
            double a18 = a2.get(a15 + 1) * a4.lambda * (a16 - a4.dx / 2.0 * a17) + a2.get(a15) * (1.0 - 2.0 * a4.lambda * a16) + a2.get(a15 - 1) * a4.lambda * (a16 + a4.dx / 2.0 * a17) + a4.pde.R(a5, a4.x[a15]) * a4.dt;
            a7.set(a15, a18);
        }
        double a19 = a4.pde.sigma(a5, a4.x[a4.n]);
        double a20 = a4.pde.mu(a5, a4.x[a4.n]);
        double a21 = a2.get(a4.n - 1) * a4.lambda * (a19 + a4.dx / 2.0 * a20) + a2.get(a4.n) * (1.0 - 2.0 * a4.lambda * a19 + a4.lambda * a9 / a11 * (a19 - a4.dx / 2.0 * a20)) + a4.lambda * (a4.pde.g2(a3) + a4.pde.g2(a6)) * a4.dx / a11 * (a19 - a4.dx / 2.0 * a20) + a4.pde.R(a5, a4.x[a4.n]) * a4.dt;
        a7.set(a4.n, a21);
        return a7;
    }

    void initialize(ConvectionDiffusionEquation1D a2, int a3, int a4) {
        PropagationOverTime a5;
        ArgumentAssertion.assertGreaterThan(a3, 0, "the number of time-axis grid points");
        ArgumentAssertion.assertGreaterThan(a4, 0, "the number of space-axis grid points");
        a5.pde = a2;
        a5.m = a3;
        a5.n = a4;
        a5.x = DoubleUtils.seq(0.0, a2.a(), a4 + 2);
        a5.dt = a2.T() / (double)a3;
        a5.dx = a5.x[1];
        a5.lambda = 0.5 * a5.dt / (a5.dx * a5.dx);
    }
}

