/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentialequation.pde.finitedifference.parabolic.dim2;

import com.numericalmethod.suanshu.analysis.differentialequation.pde.PDE;
import com.numericalmethod.suanshu.analysis.function.rn2r1.BivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.TrivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HeatEquation2D
implements PDE {
    private final double char;
    private final BivariateRealFunction new;
    private final double const;
    private final double case;
    private final TrivariateRealFunction false;
    private final double enum;

    public double T() {
        return this.enum;
    }

    public HeatEquation2D(double beta, double T2, double a2, double b2, BivariateRealFunction f, TrivariateRealFunction g2) {
        ArgumentAssertion.assertPositive(beta, "beta");
        ArgumentAssertion.assertPositive(T2, "T");
        ArgumentAssertion.assertPositive(a2, "a");
        ArgumentAssertion.assertPositive(b2, "b");
        this.const = beta;
        this.enum = T2;
        this.char = a2;
        this.case = b2;
        this.new = f;
        this.false = g2;
    }

    public double g(double t, double x, double y) {
        ArgumentAssertion.assertRange(t, 0.0, this.enum, "t");
        return this.false.evaluate(t, x, y);
    }

    public double beta() {
        return this.const;
    }

    public double f(double x, double y) {
        ArgumentAssertion.assertRangeOpen(x, 0.0, this.char, "x");
        ArgumentAssertion.assertRangeOpen(y, 0.0, this.case, "y");
        return this.new.evaluate(x, y);
    }

    static {
        Package.validate("OPDE");
    }

    public double b() {
        return this.case;
    }

    public double a() {
        return this.char;
    }
}

