/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.curvefit.interpolation.NevilleTable;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.MultivariateFiniteDifference;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractRealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.tuple.PartialFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Ridders
extends AbstractRealScalarFunction {
    private MyFunction super;
    private NevilleTable char;
    private static final int new = 15;
    private final RealScalarFunction const;
    private final int case;
    private final double false;
    private final int enum;

    public Ridders(final UnivariateRealFunction f, final int order, double rate, int discretization) {
        super(f.dimensionOfDomain());
        ArgumentAssertion.assertPositive(order, "the order of derivative");
        this.const = f;
        this.enum = order;
        this.false = rate;
        this.case = discretization;
        this.super = new MyFunction(){
            private final FiniteDifference enum;

            @Override
            public double evaluate(Vector x, double h) {
                return this.enum.evaluate(x.get(1), h);
            }
            {
                1 a2;
                a2.enum = new FiniteDifference(a2.f, a2.order, FiniteDifference.Type.CENTRAL);
            }
        };
    }

    @Override
    public double evaluate(double x) {
        if (this.const.dimensionOfDomain() != 1) {
            throw new IllegalArgumentException("f is not a univariate function");
        }
        return this.evaluate(new DenseVector(x));
    }

    public Ridders(final RealScalarFunction f, final int[] varidx, double rate, int discretization) {
        super(f.dimensionOfDomain());
        this.const = f;
        this.enum = varidx.length;
        this.false = rate;
        this.case = discretization;
        this.super = new MyFunction(){
            private final MultivariateFiniteDifference enum;

            @Override
            public double evaluate(Vector x, double h) {
                return this.enum.evaluate(x, h);
            }
            {
                2 a2;
                a2.enum = new MultivariateFiniteDifference(a2.f, a2.varidx);
            }
        };
    }

    private double do(Vector a2, double a3) {
        Ridders a4;
        double a5 = a4.super.evaluate(a2, a3);
        return a5;
    }

    public Ridders(RealScalarFunction f, int[] varidx) {
        this(f, varidx, 0.75, 15);
    }

    public Ridders(UnivariateRealFunction f, int order) {
        this(f, order, 0.75, 15);
    }

    @Override
    public Double evaluate(Vector x) {
        double a2 = x.norm();
        double a3 = 15.0 * Math.pow(Constants.EPSILON, 1.0 / (double)(this.enum + 1)) * Math.max(0.1, a2);
        return this.evaluate(x, a3);
    }

    public double evaluate(Vector x, double h) {
        double a2 = h;
        double a3 = this.do(x, a2);
        this.char = new NevilleTable();
        this.char.addData(new PartialFunction(new double[]{a2}, new double[]{a3}));
        double a4 = a3;
        double a5 = Double.MAX_VALUE;
        double a6 = a2;
        for (int a7 = 2; a7 <= this.case; ++a7) {
            double a8 = this.do(x, a6 *= this.false);
            this.char.addData(new PartialFunction(new double[]{a6}, new double[]{a8}));
            this.char.evaluate(0.0);
            for (int a9 = a7 - 2; a9 >= 0; --a9) {
                double a10;
                double a11 = this.char.get(a9, a7 - 1);
                double a12 = Math.abs(a11 - this.char.get(a9, a7 - 2));
                double a13 = Math.max(a12, a10 = Math.abs(a11 - this.char.get(a9 + 1, a7 - 1)));
                if (!(a13 < a5)) continue;
                a4 = a11;
                a5 = a13;
            }
            if (Math.abs(a8 - this.char.get(a7 - 2, a7 - 2)) > 2.0 * a5) break;
        }
        return a4;
    }

    private static interface MyFunction {
        public double evaluate(Vector var1, double var2);
    }
}

