/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.multivariate;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.MultivariateFiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;

public class BorderedHessian
extends SymmetricMatrix {
    public BorderedHessian(RealScalarFunction f, RealScalarFunction g2, Vector x) {
        super(f.dimensionOfDomain() + 1);
        int a2;
        ArgumentAssertion.assertEqual(f.dimensionOfDomain(), g2.dimensionOfDomain(), "f's dimension of domain", "g's dimension of domain");
        for (a2 = 2; a2 <= this.nRows(); ++a2) {
            MultivariateFiniteDifference a3 = new MultivariateFiniteDifference(g2, new int[]{a2 - 1});
            double a4 = a3.evaluate(x);
            super.set(1, a2, a4);
        }
        for (a2 = 2; a2 <= this.nRows(); ++a2) {
            for (int a5 = a2; a5 <= this.nCols(); ++a5) {
                MultivariateFiniteDifference a6 = new MultivariateFiniteDifference(f, new int[]{a2 - 1, a5 - 1});
                double a7 = a6.evaluate(x);
                super.set(a2, a5, a7);
            }
        }
    }
}

