/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.multivariate;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.MultivariateFiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.R1Projection;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import java.util.List;

public class Jacobian
extends DenseMatrix {
    public Jacobian(final RealScalarFunction[] f, Vector x) {
        this(new RealVectorFunction(){
            {
                1 a2;
            }

            @Override
            public int dimensionOfDomain() {
                return f[0].dimensionOfDomain();
            }

            @Override
            public Vector evaluate(Vector x) {
                double[] a2 = new double[f.length];
                for (int a3 = 0; a3 < f.length; ++a3) {
                    double a4;
                    a2[a3] = a4 = ((Double)f[a3].evaluate(x)).doubleValue();
                }
                return new DenseVector(a2);
            }

            @Override
            public int dimensionOfRange() {
                return f.length;
            }
        }, (Vector)new DenseVector(x));
    }

    public Jacobian(List<RealScalarFunction> f, Vector x) {
        this(f.toArray(new RealScalarFunction[0]), x);
    }

    public Jacobian(RealVectorFunction f, Vector x) {
        super(f.dimensionOfRange(), f.dimensionOfDomain());
        for (int a2 = 1; a2 <= this.nRows(); ++a2) {
            R1Projection a3 = new R1Projection(f, a2);
            for (int a4 = 1; a4 <= this.nCols(); ++a4) {
                MultivariateFiniteDifference a5 = new MultivariateFiniteDifference(a3, new int[]{a4});
                super.set(a2, a4, a5.evaluate(x));
            }
        }
    }
}

