/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.CubicRoot;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.LinearRoot;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolyRootSolver;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.QuadraticRoot;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.QuarticRoot;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub.JenkinsTraubReal;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.number.NumberUtils;
import com.numericalmethod.suanshu.number.complex.Complex;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PolyRoot
implements PolyRootSolver {
    private final QuadraticRoot new;
    private final CubicRoot const;
    private final QuarticRoot case;
    private final LinearRoot false = new LinearRoot();
    private final JenkinsTraubReal enum;

    public PolyRoot() {
        this.new = new QuadraticRoot();
        this.const = new CubicRoot();
        this.case = new QuarticRoot();
        this.enum = new JenkinsTraubReal();
    }

    public static List<Complex> getComplexRoots(List<? extends Number> roots) {
        ArrayList<Complex> a2 = new ArrayList<Complex>();
        for (Number number : roots) {
            if (NumberUtils.isReal(number)) continue;
            a2.add((Complex)number);
        }
        return a2;
    }

    public static List<Double> getRealRoots(List<? extends Number> roots) {
        ArrayList<Double> a2 = new ArrayList<Double>();
        for (Number number : roots) {
            if (!NumberUtils.isReal(number)) continue;
            a2.add((Double)number);
        }
        return a2;
    }

    @Override
    public List<? extends Number> solve(Polynomial polynomial) {
        ArgumentAssertion.assertTrue(polynomial.degree() != 0, "this polynomial is a constant %f", polynomial.getCoefficient(0));
        int a2 = polynomial.degree();
        switch (a2) {
            case 1: {
                return this.false.solve(polynomial);
            }
            case 2: {
                return this.new.solve(polynomial);
            }
            case 3: {
                return this.const.solve(polynomial);
            }
            case 4: {
                return this.case.solve(polynomial);
            }
        }
        return this.enum.solve(polynomial);
    }
}

