/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.rn2r1;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractRealScalarFunction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QuadraticFunction
extends AbstractRealScalarFunction {
    private final ImmutableVector case;
    private final double false;
    private final ImmutableMatrix enum;

    public String toString() {
        return String.format("1/2 * x'%sx + x'%s", this.enum, this.case);
    }

    public QuadraticFunction(Matrix H, Vector p, double c2) {
        super(p.size());
        this.enum = new ImmutableMatrix(H);
        this.case = new ImmutableVector(p);
        this.false = c2;
    }

    public QuadraticFunction(Matrix H, Vector p) {
        this(H, p, 0.0);
    }

    @Override
    public Double evaluate(Vector z) {
        DenseMatrix a2 = new DenseMatrix(z);
        Matrix a3 = a2.t();
        Matrix a4 = a3.multiply(this.enum).multiply(a2);
        Vector a5 = a3.multiply(this.case);
        double a6 = 0.5 * a4.get(1, 1) + a5.get(1) + this.false;
        return a6;
    }

    public ImmutableMatrix Hessian() {
        return this.enum;
    }

    public QuadraticFunction(QuadraticFunction f) {
        this(f.enum, f.case, f.false);
    }

    public ImmutableVector p() {
        return this.case;
    }
}

