/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special.gamma;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.gamma.Gamma;
import com.numericalmethod.suanshu.analysis.function.special.gamma.GammaLanczosQuick;
import com.numericalmethod.suanshu.analysis.function.special.gamma.Lanczos;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaLanczos
extends AbstractUnivariateRealFunction
implements Gamma {
    private final Lanczos enum;

    public GammaLanczos(double g2, int n, int scale) {
        this.enum = new Lanczos(g2, n, scale);
    }

    @Override
    public double evaluate(double x) {
        if (DoubleUtils.isZero(x, 0.0)) {
            return Double.POSITIVE_INFINITY;
        }
        double a2 = x > 0.0 ? x : -x;
        double a3 = this.enum.logGamma(a2);
        a3 = Math.exp(a3);
        a3 = x > 0.0 ? a3 : GammaLanczosQuick.reflectionFormula(-x, a3);
        return a3;
    }

    public GammaLanczos() {
        this.enum = new Lanczos();
    }
}

