/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special.gamma;

import com.numericalmethod.suanshu.analysis.function.rn2r1.AbstractBivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.ContinuedFraction;
import com.numericalmethod.suanshu.analysis.function.special.gamma.LogGamma;
import com.numericalmethod.suanshu.analysis.sequence.Summation;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaRegularizedQ
extends AbstractBivariateRealFunction {
    private static final double false;
    private static final LogGamma enum;

    private double byte(double a2, double a3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double evaluate(double s, double x) {
        ArgumentAssertion.assertTrue(DoubleUtils.compare(s, 0.0, false) >= 0, "s must be non-negative", new Object[0]);
        ArgumentAssertion.assertTrue(DoubleUtils.compare(x, 0.0, false) >= 0, "x < 0 gives complex number; not supported yet", new Object[0]);
        if (DoubleUtils.isZero(s, 0.0)) {
            return 0.0;
        }
        if (DoubleUtils.isZero(x, 0.0)) {
            return 1.0;
        }
        if (x > 1.0E8) {
            return 0.0;
        }
        if (x < s + 1.0) {
            return this.break(s, x);
        }
        return this.do(s, x);
    }

    static {
        enum = new LogGamma();
        false = Constants.EPSILON;
    }

    private double break(final double a2, final double a3) {
        GammaRegularizedQ a4;
        Summation a5 = new Summation(new Summation.Term(){
            double term;
            {
                1 a22;
            }

            @Override
            public double evaluate(double n) {
                this.term = n == 0.0 ? 1.0 / a2 : (this.term *= a3 / (a2 + n));
                return this.term;
            }
        }, false);
        double a6 = a5.sumToInfinity(0);
        double a7 = a2 * Math.log(a3) - a3 - enum.evaluate(a2);
        a7 = Math.exp(a7);
        return 1.0 - a7 * a6;
    }

    private double do(final double a2, double a3) {
        GammaRegularizedQ a4;
        ContinuedFraction a5 = new ContinuedFraction(new ContinuedFraction.Partials(){
            {
                2 a22;
            }

            @Override
            public double A(int n, double u) {
                if (n == 1) {
                    return 1.0;
                }
                return (double)(n - 1) * (a2 - (double)(n - 1));
            }

            @Override
            public double B(int n, double u) {
                if (n == 0) {
                    return 0.0;
                }
                return (double)(2 * n - 1) - a2 + u;
            }
        });
        double a6 = a2 * Math.log(a3) - a3 - enum.evaluate(a2);
        a6 = Math.exp(a6);
        return a6 *= a5.evaluate(a3);
    }
}

