/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.OrthogonalPolynomialFamily;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;

public class LaguerrePolynomials
implements OrthogonalPolynomialFamily {
    @Override
    public Polynomial getPolynomial(int order) {
        ArgumentAssertion.assertNonNegative(order, "the order of the Laguerre Polynomial");
        if (order == 0) {
            return Polynomial.ONE;
        }
        Polynomial a2 = new Polynomial(1.0, 0.0);
        if (order == 1) {
            return Polynomial.ONE.minus(a2);
        }
        Polynomial[] a3 = new Polynomial[order + 1];
        a3[0] = Polynomial.ONE;
        a3[1] = Polynomial.ONE.minus(a2);
        for (int a4 = 2; a4 <= order; ++a4) {
            Polynomial a5;
            Polynomial a6 = a3[a4 - 1].multiply(new Polynomial(new double[]{2 * (a4 - 1) + 1}).minus(a2));
            Polynomial a7 = a3[a4 - 2].scaled(a4 - 1);
            a3[a4] = a5 = a6.minus(a7).scaled(1.0 / (double)a4);
        }
        return a3[a3.length - 1];
    }
}

