/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule;

import com.numericalmethod.suanshu.analysis.differentiation.univariate.DPolynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureRule;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureUtils;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.gaussian.rule.LegendrePolynomials;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LegendreRule
implements GaussianQuadratureRule {
    private final double[] case;
    private final double[] false;
    private final Polynomial enum;

    @Override
    public boolean supportsInterval(double a2, double b2) {
        return a2 == -1.0 && b2 == 1.0;
    }

    @Override
    public double[] getCoefficients() {
        return Arrays.copyOf(this.case, this.case.length);
    }

    @Override
    public double[] getEvaluationPoints() {
        return Arrays.copyOf(this.false, this.false.length);
    }

    private static double[] do(Polynomial a2) {
        return GaussianQuadratureUtils.solveForEvaluationPointsFromPolynomial(a2);
    }

    private static double[] do(Polynomial a2, double[] a3) {
        int a4 = a2.degree();
        double[] a5 = new double[a4];
        DPolynomial a6 = new DPolynomial(a2);
        for (int a7 = 0; a7 < a4; ++a7) {
            double a8 = a3[a7];
            double a9 = a6.evaluate(a8);
            a5[a7] = 2.0 / ((1.0 - a8 * a8) * (a9 * a9));
        }
        return a5;
    }

    public LegendreRule(int n) {
        this.enum = new LegendrePolynomials().getPolynomial(n);
        this.false = LegendreRule.do(this.enum);
        this.case = LegendreRule.do(this.enum, this.false);
    }

    @Override
    public double getWeighting(double x) {
        return 1.0;
    }
}

