/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.substitution.SubstitutionRule;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PowerLawSingularity
implements SubstitutionRule {
    private final double const;
    private final double case;
    private final PowerLawSingularityType false;
    private final double enum;

    @Override
    public double tb() {
        return Math.pow(this.const - this.case, 1.0 - this.enum);
    }

    public PowerLawSingularity(PowerLawSingularityType type, double gamma, double a2, double b2) {
        this.false = type;
        this.enum = gamma;
        this.case = a2;
        this.const = b2;
    }

    @Override
    public UnivariateRealFunction dx() {
        return new AbstractUnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double t) {
                return Math.pow(t, PowerLawSingularity.this.enum / (1.0 - PowerLawSingularity.this.enum)) / (1.0 - PowerLawSingularity.this.enum);
            }
        };
    }

    @Override
    public UnivariateRealFunction x() {
        return new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double t) {
                switch (PowerLawSingularity.this.false) {
                    case LOWER: {
                        return Math.pow(t, 1.0 / (1.0 - PowerLawSingularity.this.enum)) + PowerLawSingularity.this.case;
                    }
                    case UPPER: {
                        return PowerLawSingularity.this.const - Math.pow(t, 1.0 / (1.0 - PowerLawSingularity.this.enum));
                    }
                }
                throw new IllegalArgumentException("unrecognized singularity type");
            }
        };
    }

    @Override
    public double ta() {
        return 0.0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum PowerLawSingularityType {
        UPPER,
        LOWER;


        private PowerLawSingularityType() {
            PowerLawSingularityType a2;
        }
    }
}

