/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.root.univariate;

import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.root.univariate.NoRootFoundException;
import com.numericalmethod.suanshu.analysis.root.univariate.Uniroot;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BisectionRoot
implements Uniroot {
    private final int false;
    private final double enum;

    public BisectionRoot(double tol, int maxIterations) {
        ArgumentAssertion.assertPositive(tol, "tol");
        ArgumentAssertion.assertPositive(maxIterations, "maxIteration");
        this.enum = tol;
        this.false = maxIterations;
    }

    public BisectionRoot() {
        this(Constants.EPSILON, Integer.MAX_VALUE);
    }

    @Override
    public double solve(UnivariateRealFunction f, double lower, double upper, double ... guess) throws NoRootFoundException {
        ArgumentAssertion.assertTrue(lower < upper, "lower must be smaller than upper: lower=%f, upper=%f", lower, upper);
        double a2 = lower;
        double a3 = upper;
        double a4 = f.evaluate(a3);
        double a5 = f.evaluate(a2);
        ArgumentAssertion.assertTrue(a4 * a5 < 0.0, "f(lower) and f(upper) have the same sign: f(lower=%f)=%f, f(upper=%f)=%f", lower, a5, upper, a4);
        double a6 = a2;
        double a7 = a5;
        boolean a8 = false;
        for (int a9 = 0; !a8 && a9 < this.false; ++a9) {
            double a10 = (a3 - a2) / 2.0;
            a6 = a2 + a10;
            a7 = f.evaluate(a6);
            if (Math.abs(a7) < this.enum || a10 < this.enum) {
                a8 = true;
                continue;
            }
            if (a7 * a4 < 0.0) {
                a2 = a6;
                continue;
            }
            if (a7 * a5 < 0.0) {
                a3 = a6;
                continue;
            }
            throw new RuntimeException(String.format("all f(lower), f(mid), f(upper) have the same sign: f(lower=%f)=%f, f(mid=%f)=%f, f(upper=%f)=%f", a2, a5, a6, a7, a3, a4));
        }
        if (!a8) {
            throw new NoRootFoundException(a6, a7);
        }
        return a6;
    }
}

