/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.graph.algorithm.traversal;

import com.numericalmethod.suanshu.graph.Arc;
import com.numericalmethod.suanshu.graph.Edge;
import com.numericalmethod.suanshu.graph.Graph;
import com.numericalmethod.suanshu.graph.algorithm.traversal.BFS;
import com.numericalmethod.suanshu.graph.algorithm.traversal.GraphTraversal;
import com.numericalmethod.suanshu.graph.algorithm.traversal.TraversalFromRoots;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class DFS<V>
extends TraversalFromRoots<V>
implements GraphTraversal<V> {
    public boolean isCyclic() {
        List<Node<V>> a2 = this.getOrderedNodes();
        for (Node<V> a3 : a2) {
            if (!a3.isCyclic) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node<V>> getOrderedNodes() {
        List a2 = super.getOrderedNodes();
        ArrayList<Node<V>> a3 = new ArrayList<Node<V>>();
        for (GraphTraversal.Node a4 : a2) {
            a3.add((Node)a4);
        }
        return a3;
    }

    public DFS(Graph<? extends V, ? extends Edge<V>> g2) {
        super(g2);
    }

    public static <V, W extends V> List<Node<V>> DFS(Graph<W, ? extends Edge<V>> g2, V root, int time) {
        Object a2;
        IdentityHashMap<V, Node<V>> a3 = new IdentityHashMap<V, Node<V>>();
        a3.put(root, new Node<V>(root));
        Stack<Object> a4 = new Stack<Object>();
        a4.push(a3.get(root));
        while (!a4.isEmpty()) {
            a2 = (Node)a4.pop();
            ((GraphTraversal.Node)a2).setVisitTime(time++);
            ((Node)a2).color = Node.Color.GRAY;
            ArrayDeque<Node<V>> a5 = new ArrayDeque<Node<V>>();
            for (Edge a6 : g2.edges(((GraphTraversal.Node)a2).vertex())) {
                V a7 = a6.neighbor(((GraphTraversal.Node)a2).vertex());
                if (a7 == null || a7 == ((GraphTraversal.Node)a2).vertex() || !(a6 instanceof Arc) && ((GraphTraversal.Node)a2).parent() == a7) continue;
                Node<V> a8 = (Node<V>)a3.get(a7);
                if (a8 == null) {
                    a8 = new Node<V>(a7);
                    a3.put(a7, a8);
                }
                if (a8.color == Node.Color.WHITE) {
                    a8.setParent((BFS.Node<V>)a2);
                    a5.add(a8);
                    continue;
                }
                if (a8.color != Node.Color.GRAY) continue;
                a8.isCyclic = true;
            }
            if (!a5.isEmpty()) {
                a4.push(a2);
            } else {
                ((Node)a2).finishTime = time++;
                ((Node)a2).color = Node.Color.BLACK;
            }
            Iterator<Edge<Object>> a9 = a5.descendingIterator();
            while (a9.hasNext()) {
                a4.push(a9.next());
            }
        }
        a2 = new ArrayList(a3.values());
        Collections.sort(a2);
        return a2;
    }

    @Override
    public List<Node<V>> track(V root, int time) {
        return DFS.DFS(this.g, root, time);
    }

    public static class Node<V>
    extends BFS.Node<V> {
        protected boolean isCyclic = false;
        protected int finishTime;
        protected Color color = Color.WHITE;

        protected Node(V vertex) {
            super(vertex);
        }

        public boolean isCyclic() {
            return this.isCyclic;
        }

        public Color color() {
            return this.color;
        }

        public int finishTime() {
            return this.finishTime;
        }

        @Override
        public String toString() {
            StringBuilder a2 = new StringBuilder();
            a2.append(String.format("[%s->%s, ", this.parent() != null ? this.parent() : "", this.vertex()));
            a2.append(String.format("%d, %s, %d, %d]", new Object[]{this.depth(), this.color(), this.visitTime(), this.finishTime()}));
            return a2.toString();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static enum Color {
            WHITE,
            GRAY,
            BLACK;


            private Color() {
                Color a2;
            }
        }
    }
}

