/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.grid.executor;

import com.numericalmethod.suanshu.grid.executor.GridExecutor;
import com.numericalmethod.suanshu.grid.function.Function;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.license.Package;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractGridExecutor
implements GridExecutor {
    static {
        Package.validate("GRID");
    }

    @Override
    public <O> List<O> forLoop(int start, int end, Function<O, Integer> f) {
        return this.forLoop(start, end, 1, f);
    }

    @Override
    public <O> List<O> forLoop(int start, int end, int increment, Function<O, Integer> f) {
        ArgumentAssertion.assertPositive(increment, "increment");
        if (end < start) {
            return Collections.emptyList();
        }
        ArrayList<Integer> a2 = new ArrayList<Integer>((end - start) / increment);
        for (int a3 = start; a3 < end; a3 += increment) {
            a2.add(a3);
        }
        return this.map(a2, f);
    }

    @Override
    public abstract <O, I> List<O> map(List<I> var1, Function<? extends O, ? super I> var2);
}

