/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixTable;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.license.Package;

public final class PrecisionUtils {
    private PrecisionUtils() {
        PrecisionUtils a2;
    }

    public static double autoEpsilon(MatrixTable A2) {
        return PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(A2));
    }

    public static double autoEpsilon(double ... inputs) {
        double a2 = 0.0;
        for (double a3 : inputs) {
            double a4 = Math.abs(a3);
            if (!(a4 > a2)) continue;
            a2 = a4;
        }
        double a5 = a2 * Math.sqrt(inputs.length) * Constants.EPSILON * 10.0;
        if (a5 == 0.0) {
            a5 = Double.MIN_NORMAL;
        }
        return a5;
    }

    static {
        Package.validate("BASIC");
    }

    public static double autoEpsilon(double[] ... inputs) {
        double a2 = 0.0;
        for (double[] a3 : inputs) {
            double a4 = PrecisionUtils.autoEpsilon(a3);
            if (!(a4 > a2)) continue;
            a2 = a4;
        }
        return a2;
    }
}

