/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc.datastructure.time;

import com.numericalmethod.suanshu.misc.license.Package;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class JodaTimeUtils {
    public static final DateTimeZone GMT;
    public static final DateTime ENDING_OF_TIME;
    public static final DateTime BEGINNING_OF_TIME;
    public static final long BEGINNING_OF_TIME_LONG;
    public static final DateTime ORIGIN;
    public static final DateTimeZone EST;
    public static final long ENDING_OF_TIME_LONG;

    public static DateTime getDate(int year, int month, int day, DateTimeZone tz) {
        return new DateTime(year, month, day, 0, 0, 0, 0, tz);
    }

    private JodaTimeUtils() {
        JodaTimeUtils a2;
    }

    public static DateTime min(DateTime t1, DateTime t2) {
        return t1.compareTo((ReadableInstant)t2) <= 0 ? t1 : t2;
    }

    public static List<DateTime> getPeriodicInstants(DateTime startTime, Period period, int nPeriods) {
        ArrayList<DateTime> a2 = new ArrayList<DateTime>(nPeriods + 1);
        a2.add(startTime);
        DateTime a3 = startTime;
        for (int a4 = 0; a4 < nPeriods; ++a4) {
            a3 = a3.plus((ReadablePeriod)period);
            a2.add(a3);
        }
        return a2;
    }

    public static boolean isWeekend(DateTime time) {
        return time.getDayOfWeek() == 6 || time.getDayOfWeek() == 7;
    }

    public static List<Interval> getIntervals(DateTime start, DateTime end, Period period) {
        ArrayList<Interval> a2 = new ArrayList<Interval>(10);
        DateTime a3 = start;
        while (a3.isBefore((ReadableInstant)end)) {
            DateTime a4 = a3.plus((ReadablePeriod)period);
            if (a4.isAfter((ReadableInstant)end)) {
                a4 = end;
            }
            a2.add(new Interval((ReadableInstant)a3, (ReadableInstant)a4));
            a3 = a4;
        }
        return a2;
    }

    public static DateTime max(DateTime t1, DateTime t2) {
        return t1.compareTo((ReadableInstant)t2) >= 0 ? t1 : t2;
    }

    public static DateTime previousWeekDay(DateTime time) {
        DateTime a2 = new DateTime(time.getYear(), time.getMonthOfYear(), time.getDayOfMonth(), time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), time.getMillisOfSecond(), time.getZone());
        switch (time.getDayOfWeek()) {
            case 7: {
                return a2.minusDays(2);
            }
            case 1: {
                return a2.minusDays(3);
            }
        }
        return a2.minusDays(1);
    }

    public static DateTime minusWeekdayPeriod(DateTime time, Period period) {
        DateTime a2 = time;
        if (JodaTimeUtils.isWeekend(time)) {
            a2 = JodaTimeUtils.previousWeekDay(time).plusDays(1).withTime(0, 0, 0, 0);
        }
        int a3 = period.getDays() / 5;
        int a4 = period.getDays() % 5;
        Period a5 = period.minusDays(period.getDays());
        DateTime a6 = a2.minusWeeks(a3);
        a6 = a6.minusDays(a4);
        if (a4 > a2.getDayOfWeek()) {
            a6 = a6.minusDays(2);
        }
        if ((a6 = a6.minus((ReadablePeriod)a5)).getDayOfWeek() == 7) {
            a6 = a6.minusDays(2);
        }
        return a6;
    }

    public static DateTime plusWeekdayPeriod(DateTime time, Period period) {
        DateTime a2 = time;
        if (JodaTimeUtils.isWeekend(time)) {
            a2 = JodaTimeUtils.nextWeekDay(time).withTime(0, 0, 0, 0);
        }
        int a3 = period.getDays() / 5;
        int a4 = period.getDays() % 5;
        Period a5 = period.minusDays(period.getDays());
        DateTime a6 = a2.plusWeeks(a3);
        a6 = a6.plusDays(a4);
        if (a4 + a2.getDayOfWeek() > 5) {
            a6 = a6.plusDays(2);
        }
        if ((a6 = a6.plus((ReadablePeriod)a5)).getDayOfWeek() == 6) {
            a6 = a6.plusDays(2);
        }
        return a6;
    }

    public static DateTime getFirstInstantAfter(DateTime startTime, DateTimeZone zone, LocalTime time) {
        DateTime a2 = new DateTime(startTime.getYear(), startTime.getMonthOfYear(), startTime.getDayOfMonth(), time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), time.getMillisOfSecond(), zone);
        while (a2.isBefore((ReadableInstant)startTime)) {
            a2 = a2.plusDays(1);
        }
        return a2;
    }

    public static DateTime getDateTime(String str) throws ParseException {
        String a2 = str.substring(str.lastIndexOf(32) + 1, str.length());
        DateTimeZone a3 = DateTimeZone.forID((String)a2);
        SimpleDateFormat a4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSSS");
        String a5 = str.substring(0, str.lastIndexOf(32));
        return JodaTimeUtils.getDateTime(a5, a4, a3);
    }

    public static DateTime getDateTime(String str, DateFormat format, DateTimeZone tz) throws ParseException {
        if (tz != null) {
            format.setTimeZone(tz.toTimeZone());
        }
        long a2 = format.parse(str).getTime();
        return new DateTime(a2, tz);
    }

    static {
        Package.validate("BASIC");
        GMT = DateTimeZone.forID((String)"GMT");
        EST = DateTimeZone.forID((String)"EST");
        ORIGIN = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        BEGINNING_OF_TIME = new DateTime(0, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        BEGINNING_OF_TIME_LONG = BEGINNING_OF_TIME.getMillis();
        ENDING_OF_TIME = new DateTime(9999, 12, 31, 0, 0, 0, 0, DateTimeZone.UTC);
        ENDING_OF_TIME_LONG = ENDING_OF_TIME.getMillis();
    }

    public static DateTime getLastMillisecondOfDay(DateTime t) {
        return t.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).withMillisOfSecond(999);
    }

    public static DateTime getLastDayOfMonth(DateTime t) {
        return t.dayOfMonth().withMaximumValue();
    }

    public static int getNumberOfPeriodsBetween(DateTime t1, DateTime t2, Period period) {
        int a2 = 0;
        DateTime a3 = new DateTime((Object)t1);
        while (a3.isBefore((ReadableInstant)t2)) {
            ++a2;
            a3 = a3.plus((ReadablePeriod)period);
        }
        return a2;
    }

    public static DateTime nextWeekDay(DateTime time) {
        DateTime a2 = new DateTime(time.getYear(), time.getMonthOfYear(), time.getDayOfMonth(), time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), time.getMillisOfSecond(), time.getZone());
        switch (time.getDayOfWeek()) {
            case 5: {
                return a2.plusDays(3);
            }
            case 6: {
                return a2.plusDays(2);
            }
        }
        return a2.plusDays(1);
    }
}

