/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc.license;

import com.numericalmethod.suanshu.misc.StringUtils;
import com.numericalmethod.suanshu.misc.license.InvalidLicense;
import com.numericalmethod.suanshu.misc.license.LicenseError;
import com.numericalmethod.suanshu.misc.license.LicenseSource;
import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.misc.license.verifier.DateVerifier;
import com.numericalmethod.suanshu.misc.license.verifier.IkvmVerifier;
import com.numericalmethod.suanshu.misc.license.verifier.LicenseTerm;
import com.numericalmethod.suanshu.misc.license.verifier.MacAddressVerifier;
import com.numericalmethod.suanshu.misc.license.verifier.SignatureVerifier;
import com.numericalmethod.suanshu.misc.license.verifier.Version;
import com.numericalmethod.suanshu.misc.license.verifier.VersionVerifier;
import com.numericalmethod.suanshu.zzz.con.prn.aux.nul.E;
import com.numericalmethod.suanshu.zzz.con.prn.aux.nul.j;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class License {
    private static LicenseSource case;
    public static final String[] DEFAULT_LICENSE_FILES;
    public static final String LICENSE_FILE_PROPERTY = "suanshu.license";
    private static final Version false;
    private static j enum;
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd";

    private static j false() {
        if (enum == null) {
            URL a2 = null;
            for (String a3 : DEFAULT_LICENSE_FILES) {
                String a4 = System.getProperty(LICENSE_FILE_PROPERTY, a3);
                try {
                    a2 = E.do(a4);
                }
                catch (FileNotFoundException a5) {
                    // empty catch block
                }
            }
            if (a2 == null) {
                throw new LicenseError("license file not found - put the license file in the classpath, working directory, or next to suanshu.jar");
            }
            License.do(a2);
        }
        return enum;
    }

    static LicenseSource getLicenseSource() {
        return case;
    }

    static boolean isValidated(Package a2) {
        License.checkDotNetValidity();
        if (!License.do(a2.name)) {
            return false;
        }
        return Boolean.parseBoolean(License.false().byte(a2.name));
    }

    public static void setLicenseFile(File licenseFile) {
        License.goto();
        case = LicenseSource.fromFile(licenseFile);
        try {
            enum = E.do(licenseFile);
        }
        catch (IOException a2) {
            throw new LicenseError("error loading license file");
        }
        License.byte();
    }

    private static void do(URL a2) {
        License.goto();
        case = LicenseSource.fromUrl(a2);
        try {
            enum = E.do(a2);
        }
        catch (IOException a3) {
            throw new LicenseError("error loading license file");
        }
        License.byte();
    }

    static boolean isValidated(Date a2) {
        String a3 = License.false().byte(LicenseTerm.START_DATE.term());
        String a4 = License.false().byte(LicenseTerm.EXPIRY.term());
        DateVerifier a5 = new DateVerifier(a2);
        return a5.verify(a3, a4);
    }

    private static void goto() {
        if (enum != null) {
            throw new LicenseError("license has been loaded already");
        }
    }

    private static void class() {
        SignatureVerifier a2 = new SignatureVerifier();
        a2.verify(enum);
    }

    public static String getVersion() {
        return false.toString();
    }

    private static String final() {
        StackTraceElement a2 = Thread.currentThread().getStackTrace()[3];
        return String.format("%s::%s(%s:%s)", a2.getClassName(), a2.getMethodName(), a2.getFileName(), a2.getLineNumber());
    }

    public static String getLicenseLocation() {
        return License.getLicenseSource().toString();
    }

    static void checkDotNetValidity() {
        if (License.isDotNetLicensed()) {
            IkvmVerifier a2 = new IkvmVerifier();
            a2.verify();
        }
    }

    private License() {
        License a2;
    }

    static {
        DEFAULT_LICENSE_FILES = new String[]{"numericalmethod.lic", "suanshu.lic"};
        false = new Version(3, 1, 2);
        case = LicenseSource.notLoaded();
    }

    static boolean isValidated(Package a2, Version a3) {
        if (!License.do(a2.name)) {
            return false;
        }
        String a4 = License.false().byte(a2.name);
        VersionVerifier a5 = new VersionVerifier(a3);
        return a5.verify(a4);
    }

    private static boolean do(String a2) {
        return License.false().goto(a2);
    }

    public static void setLicenseKey(String key) {
        License.goto();
        case = LicenseSource.fromKey(key, License.final());
        try {
            enum = j.do(key);
        }
        catch (Exception a2) {
            throw new InvalidLicense("invalid license key");
        }
        License.byte();
    }

    private static void byte() {
        License.class();
        License.break();
        License.do();
    }

    private static void break() {
        String a2 = License.false().byte(LicenseTerm.SUANSHU.term()).trim();
        if (StringUtils.isNullOrEmpty(a2)) {
            a2 = License.false().byte(LicenseTerm.VERSION.term()).trim();
        }
        VersionVerifier a3 = new VersionVerifier(false);
        a3.verify(a2);
    }

    public static String getLicenseKey() {
        return License.false().byte();
    }

    private static void do() {
        List<String> a2 = Arrays.asList(License.false().byte(LicenseTerm.MAC_ADDRESSES.term()).split(","));
        MacAddressVerifier a3 = new MacAddressVerifier();
        a3.verify(a2);
    }

    static boolean isDotNetLicensed() {
        return License.do("DOTNET") && Boolean.parseBoolean(License.false().byte("DOTNET"));
    }
}

