/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.license.Package;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DoubleUtils {
    public static final String CSV_SEPARATOR = ",";

    public static double[] readCSV1d(String fileName, boolean hasIndex, boolean hasHeading, String separator) throws IOException {
        return DoubleUtils.readCSV1d(new FileInputStream(fileName), hasIndex, hasHeading, separator);
    }

    public static List<Double> doubleArray2List(double ... arr) {
        ArrayList<Double> a2 = new ArrayList<Double>(arr.length);
        for (int a3 = 0; a3 < arr.length; ++a3) {
            a2.add(new Double(arr[a3]));
        }
        return a2;
    }

    public static double[][] readCSV2d(String fileName) throws IOException {
        return DoubleUtils.readCSV2d(fileName, true, true);
    }

    private DoubleUtils() {
        DoubleUtils a2;
    }

    public static double[] diff(double[] arr) {
        return DoubleUtils.diff(arr, 1, 1);
    }

    public static int[] doubleArray2intArray(double ... arr) {
        int[] a2 = new int[arr.length];
        for (int a3 = 0; a3 < arr.length; ++a3) {
            a2[a3] = (int)arr[a3];
        }
        return a2;
    }

    public static int[] subarray(int[] arr, int[] indices) {
        ArgumentAssertion.assertPositive(arr.length, "arr length");
        ArgumentAssertion.assertPositive(indices.length, "indices length");
        ArgumentAssertion.assertTrue(arr.length >= indices.length, "too many indices", new Object[0]);
        int[] a2 = new int[indices.length];
        for (int a3 = 0; a3 < indices.length; ++a3) {
            a2[a3] = arr[indices[a3]];
        }
        return a2;
    }

    public static int maxIndex(boolean moveOnTies, int from, int to, double ... doubles) {
        double a2 = Double.NEGATIVE_INFINITY;
        int a3 = -1;
        for (int a4 = from; a4 < to; ++a4) {
            if (Double.isNaN(doubles[a4]) || !(doubles[a4] > a2) && (doubles[a4] != a2 || !moveOnTies)) continue;
            a2 = doubles[a4];
            a3 = a4;
        }
        if (a3 == -1) {
            return moveOnTies ? to - 1 : from;
        }
        return a3;
    }

    public static boolean equal(int[] d1, int[] d2) {
        if (d1.length != d2.length) {
            return false;
        }
        for (int a2 = 0; a2 < d1.length; ++a2) {
            if (d1[a2] == d2[a2]) continue;
            return false;
        }
        return true;
    }

    public static long[] collection2LongArray(Collection<Long> integers) {
        long[] a2 = new long[integers.size()];
        int a3 = 0;
        for (Long a4 : integers) {
            a2[a3++] = a4;
        }
        return a2;
    }

    public static double[] select(double[] arr, which test) {
        ArrayList<Double> a2 = new ArrayList<Double>();
        for (int a3 = 0; a3 < arr.length; ++a3) {
            if (!test.isTrue(arr[a3], a3)) continue;
            a2.add(arr[a3]);
        }
        return DoubleUtils.collection2DoubleArray(a2);
    }

    public static void reverse(int ... arr) {
        int a2 = 0;
        int a3 = 0;
        int a4 = arr.length - 1;
        while (a3 < arr.length / 2) {
            a2 = arr[a3];
            arr[a3] = arr[a4];
            arr[a4] = a2;
            ++a3;
            --a4;
        }
    }

    public static double[] foreach(double[] doubles, UnivariateRealFunction f) {
        double[] a2 = new double[doubles.length];
        for (int a3 = 0; a3 < doubles.length; ++a3) {
            a2[a3] = f.evaluate(doubles[a3]);
        }
        return a2;
    }

    public static double[] leftShiftCopy(double[] arr, int k2) {
        double[] a2 = new double[arr.length];
        System.arraycopy(arr, k2, a2, 0, arr.length - k2);
        return a2;
    }

    public static boolean isNegative(double d, double epsilon) {
        return DoubleUtils.compare(d, 0.0, epsilon) == -1;
    }

    public static int[] which(double[] arr, which test) {
        ArrayList<Integer> a2 = new ArrayList<Integer>();
        for (int a3 = 0; a3 < arr.length; ++a3) {
            if (!test.isTrue(arr[a3], a3)) continue;
            a2.add(a3);
        }
        int[] a4 = new int[a2.size()];
        for (int a5 = 0; a5 < a4.length; ++a5) {
            a4[a5] = (Integer)a2.get(a5);
        }
        return a4;
    }

    public static void rightShift(double ... arr) {
        DoubleUtils.rightShift(arr, 1);
    }

    public static int[] rep(int value, int times) {
        ArgumentAssertion.assertNonNegative(times, "the number of repetitions");
        int[] a2 = new int[times];
        for (int a3 = 0; a3 < times; ++a3) {
            a2[a3] = value;
        }
        return a2;
    }

    public static int[] seq(int from, int to, int inc) {
        double a2 = (to - from) / inc + 1;
        int a3 = (int)DoubleUtils.round(a2, RoundingScheme.DOWN);
        int[] a4 = new int[a3];
        int a5 = 0;
        int a6 = from;
        do {
            a4[a5++] = a6;
        } while ((inc <= 0 || (a6 += inc) <= to) && (inc >= 0 || a6 >= to));
        return a4;
    }

    public static double[] seq(int n, double start, double inc) {
        ArgumentAssertion.assertPositive(n, "n");
        double[] a2 = new double[n];
        for (int a3 = 0; a3 < n; ++a3) {
            a2[a3] = start + inc * (double)a3;
        }
        return a2;
    }

    public static void rightShift(double[] arr, int k2) {
        int a2 = arr.length - 1;
        for (int a3 = arr.length - k2 - 1; a3 >= 0 && a2 >= 0; --a2, --a3) {
            arr[a2] = arr[a3];
        }
        Arrays.fill(arr, 0, k2, 0.0);
    }

    public static double[] ifelse(double[] arr, ifelse selection) {
        double[] a2 = new double[arr.length];
        for (int a3 = 0; a3 < arr.length; ++a3) {
            double a4 = arr[a3];
            a2[a3] = selection.test(a4) ? selection.yes(a4) : selection.no(a4);
        }
        return a2;
    }

    private static void do(List<List<String>> a2) {
        int a3 = a2.size();
        int a4 = a2.get(0).size();
        for (int a5 = 0; a5 < a3; ++a5) {
            List<String> a6 = a2.get(a5);
            ArgumentAssertion.assertTrue(a6.size() == a4, "rows have different lengths (line %d)", a5);
        }
    }

    public static double[] rightShiftCopy(double ... arr) {
        return DoubleUtils.rightShiftCopy(arr, 1);
    }

    public static double[][] readCSV2d(InputStream stream) throws IOException {
        return DoubleUtils.readCSV2d(stream, true, true);
    }

    public static double[] toPrimitive(Double[] arr) {
        double[] a2 = new double[arr.length];
        for (int a3 = 0; a3 < arr.length; ++a3) {
            a2[a3] = arr[a3] != null ? arr[a3] : Double.NaN;
        }
        return a2;
    }

    public static double[] intArray2doubleArray(int ... arr) {
        double[] a2 = new double[arr.length];
        for (int a3 = 0; a3 < arr.length; ++a3) {
            a2[a3] = arr[a3];
        }
        return a2;
    }

    public static double[][] copy2D(double[][] raw) {
        double[][] a2 = new double[raw.length][];
        for (int a3 = 0; a3 < raw.length; ++a3) {
            a2[a3] = Arrays.copyOf(raw[a3], raw[a3].length);
        }
        return a2;
    }

    public static boolean isZero(double d, double epsilon) {
        return DoubleUtils.equal(d, 0.0, epsilon);
    }

    public static int[] cumsum(int[] arr) {
        ArgumentAssertion.assertPositive(arr.length, "arr length");
        int[] a2 = new int[arr.length];
        a2[0] = arr[0];
        for (int a3 = 1; a3 < arr.length; ++a3) {
            a2[a3] = a2[a3 - 1] + arr[a3];
        }
        return a2;
    }

    public static double[] subarray(double[] arr, int[] indices) {
        ArgumentAssertion.assertPositive(arr.length, "arr length");
        ArgumentAssertion.assertPositive(indices.length, "indices length");
        ArgumentAssertion.assertTrue(arr.length >= indices.length, "too many indices", new Object[0]);
        double[] a2 = new double[indices.length];
        for (int a3 = 0; a3 < indices.length; ++a3) {
            a2[a3] = arr[indices[a3]];
        }
        return a2;
    }

    public static double[] seq(double from, double to, int n) {
        if (n == 1 && from == to) {
            return new double[]{from};
        }
        ArgumentAssertion.assertGreaterThan(n, 1, "n");
        double a2 = (to - from) / ((double)n - 1.0);
        double[] a3 = new double[n];
        a3[0] = from;
        for (int a4 = 1; a4 < n - 1; ++a4) {
            a3[a4] = from + (double)a4 * a2;
        }
        a3[n - 1] = to;
        return a3;
    }

    public static double[][] readCSV2d(String fileName, boolean hasIndex, boolean hasHeading, String separator) throws IOException {
        return DoubleUtils.readCSV2d(new FileInputStream(fileName), hasIndex, hasHeading, separator);
    }

    public static double[] readCSV1d(InputStream stream, boolean hasIndex, boolean hasHeading, String separator) throws IOException {
        double[][] a2 = DoubleUtils.readCSV2d(stream, hasIndex, hasHeading, separator);
        return DoubleUtils.concat(a2);
    }

    public static double[] collection2DoubleArray(Collection<? extends Number> numbers) {
        double[] a2 = new double[numbers.size()];
        int a3 = 0;
        for (Number number : numbers) {
            a2[a3++] = number.doubleValue();
        }
        return a2;
    }

    public static void reverse(double ... arr) {
        double a2 = 0.0;
        int a3 = 0;
        int a4 = arr.length - 1;
        while (a3 < arr.length / 2) {
            a2 = arr[a3];
            arr[a3] = arr[a4];
            arr[a4] = a2;
            ++a3;
            --a4;
        }
    }

    public static double[][] readCSV2d(String fileName, boolean hasIndex, boolean hasHeading) throws IOException {
        return DoubleUtils.readCSV2d(fileName, hasIndex, hasHeading, CSV_SEPARATOR);
    }

    public static int[] which(int[] arr, which test) {
        double[] a2 = new double[arr.length];
        for (int a3 = 0; a3 < arr.length; ++a3) {
            a2[a3] = arr[a3];
        }
        return DoubleUtils.which(a2, test);
    }

    public static boolean equal(double d1, double d2, double epsilon) {
        return DoubleUtils.compare(d1, d2, epsilon) == 0;
    }

    public static double round(double d, int scale) {
        ArgumentAssertion.assertNonNegative(scale, "scale");
        if (!DoubleUtils.isNumber(d)) {
            return d;
        }
        BigDecimal a2 = new BigDecimal(d);
        a2 = a2.setScale(scale, 4);
        return a2.doubleValue();
    }

    public static boolean isNumber(double x) {
        return !Double.isInfinite(x) && !Double.isNaN(x);
    }

    public static double[] cumsum(double[] arr) {
        ArgumentAssertion.assertPositive(arr.length, "arr length");
        double[] a2 = new double[arr.length];
        a2[0] = arr[0];
        for (int a3 = 1; a3 < arr.length; ++a3) {
            a2[a3] = a2[a3 - 1] + arr[a3];
        }
        return a2;
    }

    public static double doubleMod(double x, double y) {
        double a2 = x / y;
        a2 = a2 >= 0.0 ? Math.floor(a2) : -Math.floor(-a2);
        double a3 = x - y * a2;
        return a3;
    }

    public static int[] reverseCopy(int ... arr) {
        int[] a2 = Arrays.copyOf(arr, arr.length);
        DoubleUtils.reverse(a2);
        return a2;
    }

    public static double[] seq(double from, double to, double inc) {
        double a2 = (to - from) / inc + 1.0;
        int a3 = (int)DoubleUtils.round(a2 + Constants.EPSILON, RoundingScheme.DOWN);
        double[] a4 = new double[a3];
        for (int a5 = 0; a5 < a3; ++a5) {
            a4[a5] = from + (double)a5 * inc;
        }
        return a4;
    }

    public static double[] concat(double[] ... arr) {
        int a2 = 0;
        for (int a3 = 0; a3 < arr.length; ++a3) {
            a2 += arr[a3].length;
        }
        double[] a4 = new double[a2];
        int a5 = 0;
        for (int a6 = 0; a6 < arr.length; ++a6) {
            for (int a7 = 0; a7 < arr[a6].length; ++a7) {
                System.arraycopy(arr[a6], 0, a4, a5, arr[a6].length);
            }
            a5 += arr[a6].length;
        }
        return a4;
    }

    public static double relativeError(double x1, double x0) {
        return Math.abs(x1 / x0 - 1.0);
    }

    private static List<List<String>> do(InputStream a2, String a3) throws IOException {
        String a4;
        ArrayList<List<String>> a5 = new ArrayList<List<String>>();
        BufferedReader a6 = new BufferedReader(new InputStreamReader(a2));
        while ((a4 = a6.readLine()) != null) {
            StringTokenizer a7 = new StringTokenizer(a4, a3);
            ArrayList<String> a8 = new ArrayList<String>();
            while (a7.hasMoreTokens()) {
                a8.add(a7.nextToken());
            }
            a5.add(a8);
        }
        a6.close();
        return a5;
    }

    public static boolean hasDuplicate(double[] arr, double epsilon) {
        double[] a2 = Arrays.copyOf(arr, arr.length);
        Arrays.sort(a2);
        for (int a3 = 1; a3 < a2.length; ++a3) {
            if (!DoubleUtils.equal(a2[a3 - 1], a2[a3], epsilon)) continue;
            return true;
        }
        return false;
    }

    public static int[] collection2IntArray(Collection<Integer> integers) {
        int[] a2 = new int[integers.size()];
        int a3 = 0;
        for (Integer a4 : integers) {
            a2[a3++] = a4;
        }
        return a2;
    }

    public static int minIndex(double ... doubles) {
        return DoubleUtils.minIndex(true, 0, doubles.length, doubles);
    }

    public static boolean hasZero(double[] d, double epsilon) {
        for (int a2 = 0; a2 < d.length; ++a2) {
            if (!DoubleUtils.isZero(d[a2], epsilon)) continue;
            return true;
        }
        return false;
    }

    public static double[][] readCSV2d(InputStream stream, boolean hasIndex, boolean hasHeading, String separator) throws IOException {
        List<List<String>> a2 = DoubleUtils.do(stream, separator);
        if (a2.isEmpty()) {
            return new double[0][0];
        }
        DoubleUtils.do(a2);
        int a3 = a2.size();
        int a4 = a2.get(0).size();
        int a5 = hasIndex ? 1 : 0;
        int a6 = hasHeading ? 1 : 0;
        double[][] a7 = new double[a3 - a6][a4 - a5];
        for (int a8 = a6; a8 < a3; ++a8) {
            for (int a9 = a5; a9 < a4; ++a9) {
                a7[a8 - a6][a9 - a5] = Double.parseDouble(a2.get(a8).get(a9));
            }
        }
        return a7;
    }

    public static int[] order(double[] arr) {
        return DoubleUtils.order(arr, true);
    }

    public static double[] reverseCopy(double ... arr) {
        double[] a2 = Arrays.copyOf(arr, arr.length);
        DoubleUtils.reverse(a2);
        return a2;
    }

    public static void leftShift(double[] arr, int k2) {
        int a2 = 0;
        for (int a3 = k2; a3 < arr.length && a2 < arr.length; ++a2, ++a3) {
            arr[a2] = arr[a3];
        }
        Arrays.fill(arr, arr.length - k2, arr.length, 0.0);
    }

    public static double[] rightShiftCopy(double[] arr, int k2) {
        double[] a2 = new double[arr.length];
        System.arraycopy(arr, 0, a2, k2, arr.length - k2);
        return a2;
    }

    public static double[] readCSV1d(InputStream stream, boolean hasIndex, boolean hasHeading) throws IOException {
        return DoubleUtils.readCSV1d(stream, hasIndex, hasHeading, CSV_SEPARATOR);
    }

    public static String toString(double[][] arr) {
        StringBuilder a2 = new StringBuilder();
        a2.append("{");
        a2.append("\n");
        for (int a3 = 0; a3 < arr.length; ++a3) {
            a2.append("{");
            for (int a4 = 0; a4 < arr[a3].length; ++a4) {
                a2.append(arr[a3][a4]);
                if (a4 >= arr[a3].length - 1) continue;
                a2.append(", ");
            }
            a2.append("}");
            if (a3 < arr.length - 1) {
                a2.append(CSV_SEPARATOR);
            }
            a2.append("\n");
        }
        a2.append("};\n");
        return a2.toString();
    }

    public static double absoluteError(double x1, double x0) {
        return Math.abs(x1 - x0);
    }

    public static int[] shellsort(double ... arr) {
        int a2 = arr.length;
        int[] a3 = DoubleUtils.seq(1, a2);
        int a4 = Math.round(a2 / 2);
        while (a4 > 0) {
            for (int a5 = a4; a5 < a2; ++a5) {
                double a6 = arr[a5];
                int a7 = a3[a5];
                for (int a8 = a5; a8 >= a4 && arr[a8 - a4] > a6; a8 -= a4) {
                    arr[a8] = arr[a8 - a4];
                    a3[a8] = a3[a8 - a4];
                }
                arr[a8] = a6;
                a3[a8] = a7;
            }
            a4 = (int)Math.round((double)a4 / 2.2);
        }
        return a3;
    }

    public static double[] rep(double value, int times) {
        ArgumentAssertion.assertNonNegative(times, "the number of repetitions");
        double[] a2 = new double[times];
        for (int a3 = 0; a3 < times; ++a3) {
            a2[a3] = value;
        }
        return a2;
    }

    public static void reverseRange(double[] array, int fromIndex, int toIndex) {
        int a2 = (toIndex - fromIndex) / 2 + fromIndex;
        int a3 = fromIndex;
        int a4 = toIndex - 1;
        while (a3 < a2) {
            double a5 = array[a3];
            array[a3] = array[a4];
            array[a4] = a5;
            ++a3;
            --a4;
        }
    }

    public static double round(double d, RoundingScheme scheme) {
        switch (scheme) {
            case UP: {
                return Math.ceil(d - Constants.EPSILON);
            }
            case DOWN: {
                return Math.floor(d + Constants.EPSILON);
            }
        }
        return Math.round(d);
    }

    public static double[] leftShiftCopy(double ... arr) {
        return DoubleUtils.leftShiftCopy(arr, 1);
    }

    public static String toString(double ... arr) {
        String a2 = System.getProperty("line.separator");
        int a3 = 10;
        StringBuilder a4 = new StringBuilder();
        for (int a5 = 0; a5 < arr.length; ++a5) {
            a4.append(arr[a5]).append(", ");
            if (a5 % 10 != 9) continue;
            a4.append(a2);
        }
        return a4.toString();
    }

    public static void leftShift(double ... arr) {
        DoubleUtils.leftShift(arr, 1);
    }

    public static boolean isPow2(int n) {
        return (n & n - 1) == 0;
    }

    public static boolean isAllZeros(double[] d, double epsilon) {
        boolean a2 = true;
        for (int a3 = 0; a3 < d.length; ++a3) {
            if (DoubleUtils.isZero(d[a3], epsilon)) continue;
            a2 = false;
            break;
        }
        return a2;
    }

    public static double[][] diff(double[][] arr) {
        return DoubleUtils.diff(arr, 1, 1);
    }

    public static boolean equal(double[][] d1, double[][] d2, double epsilon) {
        int a2 = d1.length;
        if (a2 != d2.length) {
            return false;
        }
        for (int a3 = 0; a3 < a2; ++a3) {
            if (d1[a3] == null) {
                if (d2[a3] == null) continue;
                return false;
            }
            if (d2[a3] == null) {
                if (d1[a3] == null) continue;
                return false;
            }
            int a4 = d1[a3].length;
            if (a4 != d2[a3].length) {
                return false;
            }
            for (int a5 = 0; a5 < a4; ++a5) {
                if (DoubleUtils.equal(d1[a3][a5], d2[a3][a5], epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static double[][] readCSV2d(InputStream stream, boolean hasIndex, boolean hasHeading) throws IOException {
        return DoubleUtils.readCSV2d(stream, hasIndex, hasHeading, CSV_SEPARATOR);
    }

    public static double[] readCSV1d(InputStream stream) throws IOException {
        return DoubleUtils.readCSV1d(stream, true, true);
    }

    public static int minIndex(boolean moveOnTies, int from, int to, double ... doubles) {
        double a2 = Double.POSITIVE_INFINITY;
        int a3 = -1;
        for (int a4 = from; a4 < to; ++a4) {
            if (Double.isNaN(doubles[a4]) || !(doubles[a4] < a2) && (doubles[a4] != a2 || !moveOnTies)) continue;
            a2 = doubles[a4];
            a3 = a4;
        }
        if (a3 == -1) {
            return moveOnTies ? to - 1 : from;
        }
        return a3;
    }

    public static boolean equal(double[] d1, double[] d2, double epsilon) {
        if (d1.length != d2.length) {
            return false;
        }
        for (int a2 = 0; a2 < d1.length; ++a2) {
            if (DoubleUtils.equal(d1[a2], d2[a2], epsilon)) continue;
            return false;
        }
        return true;
    }

    public static double[] diff(double[] arr, int lag, int order) {
        ArgumentAssertion.assertPositive(arr.length, "array length");
        ArgumentAssertion.assertPositive(lag, "lag");
        ArgumentAssertion.assertNonNegative(order, "order");
        if (order == 0) {
            return (double[])arr.clone();
        }
        double[] a2 = (double[])arr.clone();
        double[] a3 = (double[])arr.clone();
        int a4 = 0;
        int a5 = arr.length;
        while (a4 < order) {
            int a6 = 0;
            for (int a7 = lag; a7 < a5; ++a7) {
                a3[a6] = a2[a7] - a2[a6];
                ++a6;
            }
            System.arraycopy(a3, 0, a2, 0, a5);
            ++a4;
            a5 -= lag;
        }
        return Arrays.copyOf(a3, arr.length - order * lag);
    }

    public static int[] order(double[] arr, boolean ascending) {
        ArgumentAssertion.assertPositive(arr.length, "arr length");
        double[] a2 = Arrays.copyOf(arr, arr.length);
        int[] a3 = DoubleUtils.shellsort(a2);
        if (!ascending) {
            DoubleUtils.reverse(a3);
        }
        return a3;
    }

    static {
        Package.validate("BASIC");
    }

    public static double[] readCSV1d(String fileName) throws IOException {
        return DoubleUtils.readCSV1d(fileName, true, true);
    }

    public static int[] select(int[] arr, which test) {
        ArrayList<Integer> a2 = new ArrayList<Integer>();
        for (int a3 = 0; a3 < arr.length; ++a3) {
            if (!test.isTrue(arr[a3], a3)) continue;
            a2.add(arr[a3]);
        }
        return DoubleUtils.collection2IntArray(a2);
    }

    public static List<Integer> intArray2List(int[] arr) {
        ArrayList<Integer> a2 = new ArrayList<Integer>(arr.length);
        for (int a3 = 0; a3 < arr.length; ++a3) {
            a2.add(new Integer(arr[a3]));
        }
        return a2;
    }

    public static int maxIndex(double ... doubles) {
        return DoubleUtils.maxIndex(true, 0, doubles.length, doubles);
    }

    public static boolean isPositive(double d, double epsilon) {
        return DoubleUtils.compare(d, 0.0, epsilon) == 1;
    }

    public static double[] readCSV1d(String fileName, boolean hasIndex, boolean hasHeading) throws IOException {
        return DoubleUtils.readCSV1d(fileName, hasIndex, hasHeading, CSV_SEPARATOR);
    }

    public static int compare(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) <= epsilon ? 0 : Double.compare(d1, d2);
    }

    public static double[][] diff(double[][] arr, int lag, int order) {
        DenseMatrix a2 = new DenseMatrix(arr);
        double[][] a3 = new double[a2.nCols()][];
        for (int a4 = 1; a4 <= a2.nCols(); ++a4) {
            a3[a4 - 1] = DoubleUtils.diff(a2.getColumn(a4).toArray(), lag, order);
        }
        DenseMatrix a5 = new DenseMatrix(a3);
        return MatrixUtils.to2DArray(a5.t());
    }

    public static int[] seq(int from, int to) {
        int a2 = from < to ? 1 : -1;
        return DoubleUtils.seq(from, to, a2);
    }

    public static interface which {
        public boolean isTrue(double var1, int var3);
    }

    public static interface ifelse {
        public double yes(double var1);

        public boolean test(double var1);

        public double no(double var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum RoundingScheme {
        DEFAULT,
        UP,
        DOWN;


        private RoundingScheme() {
            RoundingScheme a2;
        }
    }
}

