/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.constrained.general.sqp.activeset.equalityconstraint;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.positivedefinite.PositiveDefiniteMatrixByPositiveDiagonal;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Gradient;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Hessian;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.Jacobian;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.doublearray.DoubleArrayMath;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.constraint.EqualityConstraints;
import com.numericalmethod.suanshu.optimization.multivariate.constrained.general.sqp.activeset.equalityconstraint.SQPASEVariation;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.quasinewton.BFGSMinimizer;
import com.numericalmethod.suanshu.optimization.univariate.GridSearchMinimizer;
import java.util.List;

public class SQPASEVariation1
implements SQPASEVariation {
    protected final double epsilon = Math.sqrt(Constants.EPSILON);
    protected List<RealScalarFunction> a;
    protected int p;
    protected final int discretization;
    protected boolean foundPositiveDefiniteHessian = false;
    protected RealScalarFunction f;
    protected final double lower;
    protected final double r;

    public SQPASEVariation1(double r, double lower, int discretization) {
        this.r = r;
        this.lower = lower;
        this.discretization = discretization;
    }

    @Override
    public double alpha(final Vector x, final Vector d, Vector v) {
        AbstractUnivariateRealFunction a2 = new AbstractUnivariateRealFunction(){
            {
                1 a2;
            }

            @Override
            public double evaluate(double alpha) {
                Vector a2 = x.add(d.scaled(alpha));
                double a3 = (Double)SQPASEVariation1.this.f.evaluate(a2);
                for (int a4 = 0; a4 < SQPASEVariation1.this.p; ++a4) {
                    double a5 = (Double)SQPASEVariation1.this.a.get(a4).evaluate(a2);
                    a3 += Math.abs(SQPASEVariation1.this.r * a5);
                }
                return a3;
            }
        };
        GridSearchMinimizer a3 = new GridSearchMinimizer(this.epsilon, this.discretization);
        GridSearchMinimizer.Solution a4 = a3.solve(a2);
        double a5 = a4.search(this.lower, 1.0);
        return a5;
    }

    @Override
    public Matrix updateHessian(Vector x1, Vector v1, Vector d, Vector g0, Matrix A0, Matrix W0) {
        Gradient a2 = new Gradient(this.f, x1);
        Vector a3 = a2.minus(g0);
        Jacobian a4 = new Jacobian(this.a, x1);
        Matrix a5 = a4.minus(A0);
        Vector a6 = a5.t().multiply(v1);
        Vector a7 = a3.minus(a6);
        Matrix a8 = BFGSMinimizer.dampedBFGSHessianUpdate(W0, a7, d);
        a8 = new PositiveDefiniteMatrixByPositiveDiagonal(a8, this.epsilon, Constants.EPSILON);
        return a8;
    }

    public SQPASEVariation1() {
        this(100.0, 0.01, 50);
    }

    protected Matrix W(Vector x, Vector u) {
        Matrix a2 = new Hessian(this.f, x);
        for (int a3 = 0; a3 < this.p; ++a3) {
            double a4 = u.get(a3 + 1);
            RealScalarFunction a5 = this.a.get(a3);
            Hessian a6 = new Hessian(a5, x);
            a2 = a2.minus(a6.scaled(a4));
        }
        return a2;
    }

    @Override
    public Matrix getInitialHessian(Vector x0, Vector v0) {
        Matrix a2 = this.W(x0, v0);
        if (MatrixPropertyUtils.isPositiveDefinite(a2, this.epsilon)) {
            this.foundPositiveDefiniteHessian = true;
            return a2;
        }
        Eigen a3 = new Eigen(a2, Eigen.Method.SYMMETRY);
        double[] a4 = a3.getRealEigenvalues();
        double a5 = DoubleArrayMath.max(a4);
        if (DoubleUtils.isNegative(a5, 0.0)) {
            return a2.ONE();
        }
        a2 = new PositiveDefiniteMatrixByPositiveDiagonal(a2, this.epsilon, Constants.EPSILON);
        return a2;
    }

    public void set(RealScalarFunction f, EqualityConstraints equal) {
        this.f = f;
        this.a = equal.getConstraints();
        this.p = this.a.size();
    }
}

