/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.geneticalgorithm;

import com.numericalmethod.suanshu.misc.license.Package;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.optimization.multivariate.geneticalgorithm.Chromosome;
import com.numericalmethod.suanshu.stats.random.rng.concurrent.context.ThreadIDRNG;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class GeneticAlgorithm {
    protected final boolean parallel;
    protected final RandomLongGenerator uniform;
    protected final List<Chromosome> population = new ArrayList<Chromosome>();

    protected abstract List<? extends Chromosome> getFirstGeneration();

    protected static ArrayList<Chromosome> getNewPool(int size) {
        ArrayList<Object> a2 = new ArrayList<Object>(Collections.nCopies(size, null));
        return a2;
    }

    private GeneticAlgorithm(boolean a2, RandomLongGenerator a3) {
        GeneticAlgorithm a4;
        a4.parallel = a2;
        a4.uniform = a3;
    }

    public GeneticAlgorithm(RandomLongGenerator uniform) {
        this(uniform instanceof ThreadIDRNG, uniform);
    }

    protected List<Chromosome> getNextGeneration(List<Chromosome> parents, List<Chromosome> children) {
        int a2;
        int a3 = parents.size() + children.size();
        ArrayList<Chromosome> a4 = new ArrayList<Chromosome>(a3);
        for (a2 = 0; a2 < parents.size(); ++a2) {
            a4.add(parents.get(a2));
        }
        for (a2 = 0; a2 < children.size(); ++a2) {
            a4.add(children.get(a2));
        }
        Collections.sort(a4);
        List<Chromosome> a5 = a4.subList(0, this.nChildren());
        return a5;
    }

    protected Chromosome getBest(int i) {
        return this.population.get(i);
    }

    protected abstract boolean isConverged();

    protected Chromosome getChild(int i) {
        Chromosome a2 = this.getOne();
        Chromosome a3 = this.getOne();
        Chromosome a4 = a2.crossover(a3);
        Chromosome a5 = a4.mutate();
        return a5;
    }

    static {
        Package.validate("OPTIM");
    }

    protected Object step() {
        int a2 = this.nChildren();
        final ArrayList<Chromosome> a3 = GeneticAlgorithm.getNewPool(a2);
        if (this.parallel) {
            try {
                Inner.enum.forLoop(0, a3.size(), new LoopBody(){
                    final ThreadIDRNG uniform1;

                    @Override
                    public void run(int i) throws Exception {
                        this.uniform1.setContext(i);
                        Chromosome a2 = GeneticAlgorithm.this.getChild(i);
                        a2.fitness();
                        a3.set(i, a2);
                        Chromosome a32 = GeneticAlgorithm.this.population.get(i);
                        a32.fitness();
                    }
                    {
                        1 a2;
                        a2.uniform1 = (ThreadIDRNG)((Object)a2.GeneticAlgorithm.this.uniform);
                    }
                });
            }
            catch (Exception a4) {
                throw new RuntimeException("failed to generate children", a4);
            }
        } else {
            for (int a5 = 0; a5 < a3.size(); ++a5) {
                Chromosome a6 = this.getChild(a5);
                a3.set(a5, a6);
            }
        }
        List<Chromosome> a7 = this.getNextGeneration(this.population, a3);
        this.population.clear();
        this.population.addAll(a7);
        return true;
    }

    public void run() {
        this.population.addAll(this.getFirstGeneration());
        while (!this.isConverged()) {
            this.step();
        }
    }

    protected int nPopulation() {
        return this.population.size();
    }

    protected int nChildren() {
        return this.nPopulation();
    }

    protected Chromosome getOne() {
        double a2 = this.uniform.nextDouble();
        int a3 = (int)((double)this.nPopulation() * a2);
        return this.getBest(a3);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Inner {
        private static final ParallelExecutor enum = new ParallelExecutor(GeneticAlgorithm.class.getSimpleName());

        private Inner() {
            Inner a2;
        }
    }
}

