/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.geneticalgorithm.minimizer.simplegrid;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.optimization.Minimizer;
import com.numericalmethod.suanshu.optimization.multivariate.geneticalgorithm.Chromosome;
import com.numericalmethod.suanshu.optimization.multivariate.geneticalgorithm.GeneticAlgorithm;
import com.numericalmethod.suanshu.optimization.multivariate.geneticalgorithm.minimizer.simplegrid.SimpleCellFactory;
import com.numericalmethod.suanshu.optimization.multivariate.geneticalgorithm.minimizer.simplegrid.firstgeneration.UniformMeshOverRegion;
import com.numericalmethod.suanshu.optimization.problem.IterativeMinimizer;
import com.numericalmethod.suanshu.optimization.problem.OptimProblem;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.UniformRNG;
import java.util.List;

public class SimpleGridMinimizer
implements Minimizer<OptimProblem, IterativeMinimizer<Vector>> {
    protected final NewCellFactoryCtor factoryCtor;
    public static final int DEFAULT_STABLE_ITERATION_COUNT = 10;
    protected final double epsilon;
    protected final int maxIterations;
    protected final int nStableIterations;
    protected final RandomLongGenerator uniform;

    public SimpleGridMinimizer(double epsilon, int maxIterations) {
        this(new UniformRNG(1234567890L), epsilon, maxIterations);
    }

    @Override
    public IterativeMinimizer<Vector> solve(OptimProblem problem) throws Exception {
        return new Solution(problem.f());
    }

    public SimpleGridMinimizer(final RandomLongGenerator uniform, double epsilon, int maxIterations) {
        this(new NewCellFactoryCtor(){
            {
                1 a2;
            }

            @Override
            public SimpleCellFactory newCellFactory() {
                return new SimpleCellFactory(0.1, uniform);
            }
        }, uniform, epsilon, maxIterations, 10);
    }

    public SimpleGridMinimizer(NewCellFactoryCtor factoryCtor, RandomLongGenerator uniform, double epsilon, int maxIterations, int nStableIterations) {
        this.factoryCtor = factoryCtor;
        this.uniform = uniform;
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
        this.nStableIterations = nStableIterations;
    }

    protected class Solution
    extends GeneticAlgorithm
    implements IterativeMinimizer<Vector> {
        protected Vector[] initials;
        protected double fmin;
        protected final RealScalarFunction f;
        protected final SimpleCellFactory factory;
        protected int iteration;
        protected double fminLast;
        protected Vector xmin;
        protected int nNoChanges;

        @Override
        protected boolean isConverged() {
            double a2 = this.minimum();
            double a3 = Math.abs(a2 - this.fminLast);
            if (a2 < this.fminLast) {
                this.fminLast = a2;
            }
            this.nNoChanges = a3 < SimpleGridMinimizer.this.epsilon * Math.abs(a2) + Constants.EPSILON ? ++this.nNoChanges : 0;
            if (this.nNoChanges > SimpleGridMinimizer.this.nStableIterations) {
                return true;
            }
            return this.iteration >= SimpleGridMinimizer.this.maxIterations;
        }

        @Override
        protected List<? extends Chromosome> getFirstGeneration() {
            UniformMeshOverRegion a2 = new UniformMeshOverRegion(this.f, this.factory, SimpleGridMinimizer.this.uniform, 2, this.initials, SimpleGridMinimizer.this.epsilon);
            return a2.getFirstGeneration();
        }

        @Override
        public ImmutableVector minimizer() {
            return new ImmutableVector(this.xmin);
        }

        public Vector search(Vector ... initials) {
            this.setInitials(initials);
            super.run();
            return this.minimizer();
        }

        @Override
        public Object step() {
            ++this.iteration;
            super.step();
            SimpleCellFactory.SimpleCell a2 = (SimpleCellFactory.SimpleCell)this.getBest(0);
            this.xmin = a2.x();
            this.fmin = this.getBest(0).fitness();
            return true;
        }

        protected Solution(RealScalarFunction f) {
            super(SimpleGridMinimizer.this.uniform);
            this.iteration = 0;
            this.nNoChanges = 0;
            this.fminLast = Double.POSITIVE_INFINITY;
            this.fmin = Double.POSITIVE_INFINITY;
            this.f = f;
            this.factory = SimpleGridMinimizer.this.factoryCtor.newCellFactory();
        }

        public void setInitials(Vector ... initials) {
            this.initials = initials;
        }

        @Override
        public double minimum() {
            return this.fmin;
        }
    }

    public static interface NewCellFactoryCtor {
        public SimpleCellFactory newCellFactory();
    }
}

