/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.initialization;

import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.interval.RealInterval;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.algorithm.CartesianProduct;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.multivariate.initialization.InitialsFactory;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UniformDistributionOverBox2
implements InitialsFactory {
    private final RandomLongGenerator const;
    private final double case;
    private final int false;
    private final Double[][] enum;

    public UniformDistributionOverBox2(double scale, RealInterval[] bounds, int discretization, RandomLongGenerator uniform) {
        this(scale, bounds, DoubleUtils.rep(discretization, bounds.length), uniform);
    }

    @Override
    public Vector[] getInitials(Vector ... notused) {
        Vector[] a2 = new Vector[this.false];
        int a3 = 0;
        CartesianProduct<Double> a4 = new CartesianProduct<Double>(this.enum);
        for (List<Double> list : a4) {
            a2[a3] = new DenseVector(DoubleUtils.collection2DoubleArray(list));
            a2[a3] = this.do(a2[a3]);
            ++a3;
        }
        return a2;
    }

    public Vector[] getInitials() {
        return this.getInitials(new Vector[0]);
    }

    private Vector do(Vector a2) {
        Vector a3 = a2.deepCopy();
        for (int a4 = 1; a4 <= a3.size(); ++a4) {
            UniformDistributionOverBox2 a5;
            double a6 = 1.0 - a5.case + a5.const.nextDouble() * 2.0 * a5.case;
            a3.set(a4, a3.get(a4) * a6);
        }
        return a3;
    }

    public UniformDistributionOverBox2(double scale, RealInterval[] bounds, int[] discretizations, RandomLongGenerator uniform) {
        ArgumentAssertion.assertEqual(bounds.length, discretizations.length, "number of bounds", "number of discretizations");
        this.case = scale;
        this.const = uniform;
        int a2 = 1;
        this.enum = new Double[bounds.length][];
        for (int a3 = 0; a3 < bounds.length; ++a3) {
            this.enum[a3] = new Double[discretizations[a3] - 1];
            a2 *= this.enum[a3].length;
            double a4 = bounds[a3].upper() - bounds[a3].lower();
            a4 /= (double)discretizations[a3];
            for (int a5 = 0; a5 < discretizations[a3] - 1; ++a5) {
                this.enum[a3][a5] = bounds[a3].lower() + (double)(a5 + 1) * a4;
            }
        }
        this.false = a2;
    }
}

