/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.multivariate.unconstrained.annealing;

import com.numericalmethod.suanshu.misc.algorithm.stopcondition.StopCondition;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.annealing.SimulatedAnnealingMinimizer;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.annealing.acceptanceprobabilityfunction.GSAAcceptanceProbabilityFunction;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.annealing.annealingfunction.GSAAnnealingFunction;
import com.numericalmethod.suanshu.optimization.multivariate.unconstrained.annealing.temperaturefunction.GSATemperatureFunction;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.normal.Zignor2005;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.UniformRNG;

public class GeneralizedSimulatedAnnealingMinimizer
extends SimulatedAnnealingMinimizer {
    public static final double DEFAULT_QA = -5.0;
    public static final double DEFAULT_QV = 2.62;
    public static final double DEFAULT_INITIAL_TEMPERATURE = 5230.0;

    public GeneralizedSimulatedAnnealingMinimizer(int dim, StopCondition stopCondition) {
        this(dim, 5230.0, stopCondition, new UniformRNG(1234567890L));
    }

    public GeneralizedSimulatedAnnealingMinimizer(int dim, double initialTemperature, StopCondition stopCondition, RandomLongGenerator uniform) {
        this(dim, initialTemperature, 2.62, -5.0, stopCondition, uniform);
    }

    public GeneralizedSimulatedAnnealingMinimizer(int dim, double initialTemperature, double qv, double qa, StopCondition stopCondition, RandomLongGenerator uniform) {
        super(new GSATemperatureFunction(initialTemperature, qv), new GSAAnnealingFunction(qv, uniform, new Zignor2005(uniform)), new GSAAcceptanceProbabilityFunction(qa), GSAAnnealingFunction.GSAMarkovLength(dim), stopCondition, uniform);
    }
}

